/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.proto;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.base.Predicates;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DefaultUseRegistry;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessInfo;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessInfoCollection;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.ProtoReferences;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCodeUtils;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.conversion.OneTimeMethodProcessor;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.shaking.DefaultTreePrunerConfiguration;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.shaking.TreePrunerConfiguration;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;

public class GeneratedExtensionRegistryShrinker {
    private final AppView<AppInfoWithLiveness> appView;
    private final ProtoReferences references;
    private final Set<DexType> classesWithRemovedExtensionFields = Sets.newIdentityHashSet();
    private final Set<DexField> removedExtensionFields = Sets.newIdentityHashSet();

    GeneratedExtensionRegistryShrinker(AppView<AppInfoWithLiveness> appView, ProtoReferences references) {
        assert (appView.options().protoShrinking().enableGeneratedExtensionRegistryShrinking);
        this.appView = appView;
        this.references = references;
    }

    public TreePrunerConfiguration run(Enqueuer.Mode mode) {
        this.forEachDeadProtoExtensionField(this::recordDeadProtoExtensionField);
        return this.createTreePrunerConfiguration(mode);
    }

    private void recordDeadProtoExtensionField(DexField field) {
        this.classesWithRemovedExtensionFields.add(field.holder);
        this.removedExtensionFields.add(field);
    }

    private TreePrunerConfiguration createTreePrunerConfiguration(Enqueuer.Mode mode) {
        if (mode.isFinalTreeShaking()) {
            return new DefaultTreePrunerConfiguration(){

                @Override
                public boolean isReachableOrReferencedField(AppInfoWithLiveness appInfo, DexEncodedField field) {
                    return !GeneratedExtensionRegistryShrinker.this.wasRemoved(field.field) && super.isReachableOrReferencedField(appInfo, field);
                }
            };
        }
        return DefaultTreePrunerConfiguration.getInstance();
    }

    public void rewriteCode(DexEncodedMethod method, IRCode code) {
        if (method.isClassInitializer() && this.classesWithRemovedExtensionFields.contains(method.method.holder) && code.metadata().mayHaveStaticPut()) {
            this.rewriteClassInitializer(code);
        }
    }

    private void rewriteClassInitializer(IRCode code) {
        ArrayList<StaticPut> toBeRemoved = new ArrayList<StaticPut>();
        for (StaticPut staticPut : code.instructions(Instruction::isStaticPut)) {
            if (!this.removedExtensionFields.contains(staticPut.getField())) continue;
            toBeRemoved.add(staticPut);
        }
        for (StaticPut instruction : toBeRemoved) {
            if (!instruction.hasBlock()) continue;
            IRCodeUtils.removeInstructionAndTransitiveInputsIfNotUsed(code, instruction);
        }
    }

    public boolean wasRemoved(DexField field) {
        return this.removedExtensionFields.contains(field);
    }

    public void postOptimizeGeneratedExtensionRegistry(IRConverter converter) {
        this.forEachFindLiteExtensionByNumberMethod(method -> converter.processMethod((DexEncodedMethod)method, OptimizationFeedbackIgnore.getInstance(), OneTimeMethodProcessor.getInstance()));
    }

    private void forEachFindLiteExtensionByNumberMethod(Consumer<DexEncodedMethod> consumer) {
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            if (clazz.superType != this.references.extensionRegistryLiteType) continue;
            for (DexEncodedMethod method : clazz.methods()) {
                if (!this.references.isFindLiteExtensionByNumberMethod(method.method)) continue;
                consumer.accept(method);
            }
        }
    }

    public boolean isDeadProtoExtensionField(DexField field) {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        DexEncodedField encodedField = appInfo.resolveField(field);
        if (encodedField != null) {
            return this.isDeadProtoExtensionField(encodedField, appInfo.getFieldAccessInfoCollection(), appInfo.getPinnedItems());
        }
        return false;
    }

    public boolean isDeadProtoExtensionField(DexEncodedField encodedField, FieldAccessInfoCollection<?> fieldAccessInfoCollection, Set<DexReference> pinnedItems) {
        DexField field = encodedField.field;
        if (pinnedItems.contains(field)) {
            return false;
        }
        if (field.type != this.references.generatedExtensionType) {
            return false;
        }
        DexClass clazz = this.appView.definitionFor(encodedField.field.holder);
        if (clazz == null || !clazz.isProgramClass()) {
            return false;
        }
        Object fieldAccessInfo = fieldAccessInfoCollection.get(encodedField.field);
        if (fieldAccessInfo == null) {
            return false;
        }
        DexEncodedMethod uniqueReadContext = fieldAccessInfo.getUniqueReadContext();
        return uniqueReadContext != null && this.references.isFindLiteExtensionByNumberMethod(uniqueReadContext.method);
    }

    private void forEachDeadProtoExtensionField(Consumer<DexField> consumer) {
        FieldAccessInfoCollection<? extends FieldAccessInfo> fieldAccessInfoCollection = this.appView.appInfo().getFieldAccessInfoCollection();
        fieldAccessInfoCollection.forEach(info -> {
            DexField field = info.getField();
            if (this.isDeadProtoExtensionField(field)) {
                consumer.accept(field);
            }
        });
    }

    public void logRemainingProtoExtensionFields() {
        final Predicate<DexField> skip = this.getSkipPredicate(null);
        final Set<DexField> remainingProtoExtensionFieldReads = Sets.newIdentityHashSet();
        this.forEachFindLiteExtensionByNumberMethod(method -> {
            Log.info(GeneratedExtensionRegistryShrinker.class, "Extracting remaining proto extension field reads from method `%s`", method.method.toSourceString());
            assert (method.hasCode());
            method.getCode().registerCodeReferences((DexEncodedMethod)method, new DefaultUseRegistry(this.appView.dexItemFactory()){

                @Override
                public boolean registerStaticFieldRead(DexField field) {
                    if (!skip.test(field)) {
                        remainingProtoExtensionFieldReads.add(field);
                    }
                    return true;
                }
            });
        });
        Log.info(GeneratedExtensionRegistryShrinker.class, "Number of remaining proto extension fields: %s", remainingProtoExtensionFieldReads.size());
        FieldAccessInfoCollection<? extends FieldAccessInfo> fieldAccessInfoCollection = this.appView.appInfo().getFieldAccessInfoCollection();
        for (DexField field : remainingProtoExtensionFieldReads) {
            StringBuilder message = new StringBuilder(field.toSourceString());
            FieldAccessInfo fieldAccessInfo = fieldAccessInfoCollection.get(field);
            fieldAccessInfo.forEachReadContext(readContext -> message.append(System.lineSeparator()).append("- ").append(readContext.toSourceString()));
            Log.info(GeneratedExtensionRegistryShrinker.class, message.toString(), new Object[0]);
        }
    }

    private Predicate<DexField> getSkipPredicate(Path file) {
        if (file != null) {
            try {
                DexItemFactory dexItemFactory = this.appView.dexItemFactory();
                Set skipFields = FileUtils.readAllLines(file).stream().map(String::trim).filter(Predicates.not(String::isEmpty)).map(x -> {
                    int separatorIndex = x.lastIndexOf(".");
                    return dexItemFactory.createField(dexItemFactory.createType(DescriptorUtils.javaTypeToDescriptor(x.substring(0, separatorIndex))), this.references.generatedExtensionType, dexItemFactory.createString(x.substring(separatorIndex + 1)));
                }).collect(Collectors.toSet());
                return skipFields::contains;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Predicates.alwaysFalse();
    }
}

