/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.type;

import java.util.ArrayDeque;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;

public class DestructivePhiTypeUpdater {
    private final AppView<? extends AppInfoWithSubtyping> appView;
    private final Function<DexType, DexType> mapping;

    public DestructivePhiTypeUpdater(AppView<? extends AppInfoWithSubtyping> appView) {
        this(appView, appView.graphLense()::lookupType);
    }

    public DestructivePhiTypeUpdater(AppView<? extends AppInfoWithSubtyping> appView, Function<DexType, DexType> mapping) {
        this.appView = appView;
        this.mapping = mapping;
    }

    public void recomputeAndPropagateTypes(IRCode code, Set<Phi> affectedPhis) {
        ArrayDeque<Phi> worklist = new ArrayDeque<Phi>(affectedPhis);
        while (!worklist.isEmpty()) {
            Phi phi = (Phi)worklist.poll();
            phi.setTypeLattice(TypeLatticeElement.BOTTOM);
            for (Phi affectedPhi : phi.uniquePhiUsers()) {
                if (!affectedPhis.add(affectedPhi)) continue;
                worklist.add(affectedPhi);
            }
        }
        assert (this.verifyAllChangedPhisAreScheduled(code, affectedPhis));
        assert (this.verifyAllPhiOperandsAreBottom(affectedPhis));
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        worklist.addAll(affectedPhis);
        while (!worklist.isEmpty()) {
            Phi phi = (Phi)worklist.poll();
            TypeLatticeElement newType = phi.computePhiType(this.appView);
            if (phi.getTypeLattice().equals(newType)) continue;
            assert (!newType.isBottom());
            phi.setTypeLattice(newType);
            worklist.addAll(phi.uniquePhiUsers());
            affectedValues.addAll(phi.affectedValues());
        }
        assert (new TypeAnalysis(this.appView).verifyValuesUpToDate(affectedPhis));
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
    }

    private boolean verifyAllPhiOperandsAreBottom(Set<Phi> affectedPhis) {
        for (Phi phi : affectedPhis) {
            for (Value operand : phi.getOperands()) {
                if (!operand.isPhi()) continue;
                Phi operandPhi = operand.asPhi();
                TypeLatticeElement operandType = operandPhi.getTypeLattice();
                assert (!affectedPhis.contains(operandPhi) || operandType.isBottom());
                assert (affectedPhis.contains(operandPhi) || operandType.isPrimitive() || operandType.isNullType() || operandType.isReference() && operandType.fixupClassTypeReferences(this.mapping, this.appView) == operandType);
            }
        }
        return true;
    }

    private boolean verifyAllChangedPhisAreScheduled(IRCode code, Set<Phi> affectedPhis) {
        ListIterator<BasicBlock> blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = blocks.next();
            for (Phi phi : block.getPhis()) {
                TypeLatticeElement phiTypeLattice = phi.getTypeLattice();
                TypeLatticeElement substituted = phiTypeLattice.fixupClassTypeReferences(this.mapping, this.appView);
                assert (substituted == phiTypeLattice || affectedPhis.contains(phi));
            }
        }
        return true;
    }
}

