/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfNewArray;
import shadow.bundletool.com.android.tools.r8.code.NewArray;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;

public class NewArrayEmpty
extends Instruction {
    public final DexType type;

    public NewArrayEmpty(Value dest, Value size, DexType type) {
        super(dest, size);
        this.type = type;
    }

    @Override
    public int opcode() {
        return 46;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.type.toString();
    }

    public Value dest() {
        return this.outValue;
    }

    public Value size() {
        return (Value)this.inValues.get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int size = builder.allocatedRegister(this.size(), this.getNumber());
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)new NewArray(dest, size, this.type));
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 15;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean instructionInstanceCanThrow() {
        return this.size().definition == null || !this.size().definition.isConstNumber() || this.size().definition.asConstNumber().getRawValue() < 0L || this.size().definition.asConstNumber().getRawValue() >= Integer.MAX_VALUE;
    }

    @Override
    public boolean canBeDeadCode(AppView<?> appView, IRCode code) {
        if (this.instructionInstanceCanThrow()) {
            return false;
        }
        DexType baseType = this.type.toBaseType(appView.dexItemFactory());
        return baseType.isPrimitiveType() || appView.definitionFor(baseType) != null;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isNewArrayEmpty() && other.asNewArrayEmpty().type == this.type;
    }

    @Override
    public boolean isNewArrayEmpty() {
        return true;
    }

    @Override
    public NewArrayEmpty asNewArrayEmpty() {
        return this;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forNewArrayEmpty(this.type, invocationContext);
    }

    @Override
    public boolean hasInvariantOutType() {
        return true;
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return this.type;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        assert (this.type.isArrayType());
        builder.add(new CfNewArray(this.type));
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return TypeLatticeElement.fromDexType(this.type, Nullability.definitelyNotNull(), appView);
    }

    @Override
    public boolean instructionMayTriggerMethodInvocation(AppView<?> appView, DexType context) {
        return false;
    }
}

