/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.conversion;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CallGraphBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CallGraphBuilderBase;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CallSiteInformation;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class CallGraph {
    final Set<Node> nodes;
    final CallGraphBuilderBase.CycleEliminator.CycleEliminationResult cycleEliminationResult;

    CallGraph(Set<Node> nodes, CallGraphBuilderBase.CycleEliminator.CycleEliminationResult cycleEliminationResult) {
        this.nodes = nodes;
        this.cycleEliminationResult = cycleEliminationResult;
    }

    static CallGraphBuilder builder(AppView<AppInfoWithLiveness> appView) {
        return new CallGraphBuilder(appView);
    }

    CallSiteInformation createCallSiteInformation(AppView<AppInfoWithLiveness> appView) {
        return appView.options().isShrinking() ? new CallSiteInformation.CallGraphBasedCallSiteInformation(appView, this) : CallSiteInformation.empty();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public Set<DexEncodedMethod> extractLeaves() {
        return this.extractNodes(Node::isLeaf, Node::cleanCallersForRemoval);
    }

    public Set<DexEncodedMethod> extractRoots() {
        return this.extractNodes(Node::isRoot, Node::cleanCalleesForRemoval);
    }

    private Set<DexEncodedMethod> extractNodes(Predicate<Node> predicate, Consumer<Node> clean) {
        Set<DexEncodedMethod> result = Sets.newIdentityHashSet();
        Set<Node> removed = Sets.newIdentityHashSet();
        Iterator<Node> nodeIterator = this.nodes.iterator();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.next();
            if (!predicate.test(node)) continue;
            result.add(node.method);
            nodeIterator.remove();
            removed.add(node);
        }
        removed.forEach(clean);
        return result;
    }

    public static class Node
    implements Comparable<Node> {
        public static Node[] EMPTY_ARRAY = new Node[0];
        public final DexEncodedMethod method;
        private int numberOfCallSites = 0;
        private final Set<Node> callees = new TreeSet<Node>();
        private final Set<Node> callers = new TreeSet<Node>();

        public Node(DexEncodedMethod method) {
            this.method = method;
        }

        public void addCallerConcurrently(Node caller) {
            this.addCallerConcurrently(caller, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addCallerConcurrently(Node caller, boolean likelySpuriousCallEdge) {
            if (caller != this && !likelySpuriousCallEdge) {
                Set<Node> set = this.callers;
                synchronized (set) {
                    this.callers.add(caller);
                    ++this.numberOfCallSites;
                }
                set = caller.callees;
                synchronized (set) {
                    caller.callees.add(this);
                }
            }
            Set<Node> set = this.callers;
            synchronized (set) {
                ++this.numberOfCallSites;
            }
        }

        public void removeCaller(Node caller) {
            this.callers.remove(caller);
            caller.callees.remove(this);
        }

        public void cleanCalleesForRemoval() {
            assert (this.callers.isEmpty());
            for (Node callee : this.callees) {
                callee.callers.remove(this);
            }
        }

        public void cleanCallersForRemoval() {
            assert (this.callees.isEmpty());
            for (Node caller : this.callers) {
                caller.callees.remove(this);
            }
        }

        public Set<Node> getCallersWithDeterministicOrder() {
            return this.callers;
        }

        public Set<Node> getCalleesWithDeterministicOrder() {
            return this.callees;
        }

        public int getNumberOfCallSites() {
            return this.numberOfCallSites;
        }

        public boolean hasCallee(Node method) {
            return this.callees.contains(method);
        }

        public boolean hasCaller(Node method) {
            return this.callers.contains(method);
        }

        public boolean isRoot() {
            return this.callers.isEmpty();
        }

        public boolean isLeaf() {
            return this.callees.isEmpty();
        }

        @Override
        public int compareTo(Node other) {
            return this.method.method.slowCompareTo(other.method.method);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MethodNode for: ");
            builder.append(this.method.toSourceString());
            builder.append(" (");
            builder.append(this.callees.size());
            builder.append(" callees, ");
            builder.append(this.callers.size());
            builder.append(" callers");
            builder.append(", invoke count ").append(this.numberOfCallSites);
            builder.append(").");
            builder.append(System.lineSeparator());
            if (this.callees.size() > 0) {
                builder.append("Callees:");
                builder.append(System.lineSeparator());
                for (Node call : this.callees) {
                    builder.append("  ");
                    builder.append(call.method.toSourceString());
                    builder.append(System.lineSeparator());
                }
            }
            if (this.callers.size() > 0) {
                builder.append("Callers:");
                builder.append(System.lineSeparator());
                for (Node caller : this.callers) {
                    builder.append("  ");
                    builder.append(caller.method.toSourceString());
                    builder.append(System.lineSeparator());
                }
            }
            return builder.toString();
        }
    }
}

