/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.ClassAccessFlags;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexTypeList;
import shadow.bundletool.com.android.tools.r8.graph.NestMemberClassAttribute;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.code.Invoke;
import shadow.bundletool.com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import shadow.bundletool.com.android.tools.r8.origin.SynthesizedOrigin;
import shadow.bundletool.com.android.tools.r8.utils.BooleanUtils;
import shadow.bundletool.com.android.tools.r8.utils.Pair;

public abstract class NestBasedAccessDesugaring {
    public static final String NEST_ACCESS_NAME_PREFIX = "-$$Nest$";
    private static final String NEST_ACCESS_METHOD_NAME_PREFIX = "-$$Nest$m";
    private static final String NEST_ACCESS_STATIC_METHOD_NAME_PREFIX = "-$$Nest$sm";
    private static final String NEST_ACCESS_FIELD_GET_NAME_PREFIX = "-$$Nest$fget";
    private static final String NEST_ACCESS_STATIC_GET_FIELD_NAME_PREFIX = "-$$Nest$sfget";
    private static final String NEST_ACCESS_FIELD_PUT_NAME_PREFIX = "-$$Nest$fput";
    private static final String NEST_ACCESS_STATIC_PUT_FIELD_NAME_PREFIX = "-$$Nest$sfput";
    public static final String NEST_CONSTRUCTOR_NAME = "-$$Nest$Constructor";
    private static final String FULL_NEST_CONTRUCTOR_NAME = "L-$$Nest$Constructor;";
    protected final AppView<?> appView;
    final Map<DexMethod, DexEncodedMethod> bridges = new ConcurrentHashMap<DexMethod, DexEncodedMethod>();
    final Map<DexField, DexEncodedMethod> getFieldBridges = new ConcurrentHashMap<DexField, DexEncodedMethod>();
    final Map<DexField, DexEncodedMethod> putFieldBridges = new ConcurrentHashMap<DexField, DexEncodedMethod>();
    private final DexProgramClass nestConstructor;
    private boolean nestConstructorUsed = false;

    NestBasedAccessDesugaring(AppView<?> appView) {
        this.appView = appView;
        this.nestConstructor = this.createNestAccessConstructor();
    }

    DexType getNestConstructorType() {
        assert (this.nestConstructor != null);
        return this.nestConstructor.type;
    }

    abstract void reportMissingNestHost(DexClass var1);

    abstract void reportIncompleteNest(List<DexType> var1);

    DexClass definitionFor(DexType type) {
        return this.appView.definitionFor(this.appView.graphLense().lookupType(type));
    }

    private DexEncodedMethod definitionFor(DexMethod method, DexMethod context, Invoke.Type invokeType) {
        return this.appView.definitionFor(this.appView.graphLense().lookupMethod(method, context, invokeType).getMethod());
    }

    private DexEncodedField definitionFor(DexField field) {
        return this.appView.definitionFor(this.appView.graphLense().lookupField(field));
    }

    private Pair<DexClass, List<DexType>> extractNest(DexClass clazz) {
        DexClass hostClass;
        assert (clazz != null);
        DexClass dexClass = hostClass = clazz.isNestHost() ? clazz : this.definitionFor(clazz.getNestHost());
        if (hostClass == null) {
            this.reportMissingNestHost(clazz);
            clazz.clearNestHost();
            return null;
        }
        ArrayList<DexType> classesInNest = new ArrayList<DexType>(hostClass.getNestMembersClassAttributes().size() + 1);
        for (NestMemberClassAttribute nestmate : hostClass.getNestMembersClassAttributes()) {
            classesInNest.add(nestmate.getNestMember());
        }
        classesInNest.add(hostClass.type);
        return new Pair<DexClass, List<DexType>>(hostClass, classesInNest);
    }

    Future<?> asyncProcessNest(DexClass clazz, ExecutorService executorService) {
        return executorService.submit(() -> {
            Pair<DexClass, List<DexType>> nest = this.extractNest(clazz);
            if (nest != null) {
                this.processNest(nest.getFirst(), nest.getSecond());
            }
            return null;
        });
    }

    private void processNest(DexClass host, List<DexType> nest) {
        boolean reported = false;
        for (DexType type : nest) {
            DexClass clazz = this.definitionFor(type);
            if (clazz == null) {
                if (reported) continue;
                this.reportIncompleteNest(nest);
                reported = true;
                continue;
            }
            this.reportDesugarDependencies(host, clazz);
            if (!this.shouldProcessClassInNest(clazz, nest)) continue;
            NestBasedAccessDesugaringUseRegistry registry = new NestBasedAccessDesugaringUseRegistry(clazz);
            for (DexEncodedMethod method : clazz.methods()) {
                registry.setContext(method.method);
                method.registerCodeReferences(registry);
            }
        }
    }

    private void reportDesugarDependencies(DexClass host, DexClass clazz) {
        if (host == clazz) {
            return;
        }
        if (host.isProgramClass()) {
            InterfaceMethodRewriter.reportDependencyEdge(host.asProgramClass(), clazz, this.appView.options());
        }
        if (clazz.isProgramClass()) {
            InterfaceMethodRewriter.reportDependencyEdge(clazz.asProgramClass(), host, this.appView.options());
        }
    }

    protected abstract boolean shouldProcessClassInNest(DexClass var1, List<DexType> var2);

    private DexProgramClass createNestAccessConstructor() {
        return new DexProgramClass(this.appView.dexItemFactory().createType(FULL_NEST_CONTRUCTOR_NAME), null, new SynthesizedOrigin("Nest based access desugaring", this.getClass()), ClassAccessFlags.fromDexAccessFlags(4113), this.appView.dexItemFactory().objectType, DexTypeList.empty(), this.appView.dexItemFactory().createString("nest"), null, Collections.emptyList(), null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, DexEncodedMethod.EMPTY_ARRAY, DexEncodedMethod.EMPTY_ARRAY, this.appView.dexItemFactory().getSkipNameValidationForTesting(), DexProgramClass::checksumFromType);
    }

    void synthesizeNestConstructor(DexApplication.Builder<?> builder) {
        if (this.nestConstructorUsed) {
            ((AppInfo)this.appView.appInfo()).addSynthesizedClass(this.nestConstructor);
            builder.addSynthesizedClass(this.nestConstructor, true);
        }
    }

    public static boolean isNestConstructor(DexType type) {
        return type.getName().equals(NEST_CONSTRUCTOR_NAME);
    }

    private DexString computeMethodBridgeName(DexEncodedMethod method) {
        String methodName = method.method.name.toString();
        String fullName = method.isStatic() ? NEST_ACCESS_STATIC_METHOD_NAME_PREFIX + methodName : NEST_ACCESS_METHOD_NAME_PREFIX + methodName;
        return this.appView.dexItemFactory().createString(fullName);
    }

    private DexString computeFieldBridgeName(DexEncodedField field, boolean isGet) {
        String fieldName = field.field.name.toString();
        String fullName = isGet && !field.isStatic() ? NEST_ACCESS_FIELD_GET_NAME_PREFIX + fieldName : (isGet ? NEST_ACCESS_STATIC_GET_FIELD_NAME_PREFIX + fieldName : (!field.isStatic() ? NEST_ACCESS_FIELD_PUT_NAME_PREFIX + fieldName : NEST_ACCESS_STATIC_PUT_FIELD_NAME_PREFIX + fieldName));
        return this.appView.dexItemFactory().createString(fullName);
    }

    private DexMethod computeMethodBridge(DexEncodedMethod encodedMethod) {
        DexMethod method = encodedMethod.method;
        DexProto proto = encodedMethod.accessFlags.isStatic() ? method.proto : this.appView.dexItemFactory().prependTypeToProto(method.holder, method.proto);
        return this.appView.dexItemFactory().createMethod(method.holder, proto, this.computeMethodBridgeName(encodedMethod));
    }

    private DexMethod computeInitializerBridge(DexMethod method) {
        DexProto newProto = this.appView.dexItemFactory().appendTypeToProto(method.proto, this.nestConstructor.type);
        return this.appView.dexItemFactory().createMethod(method.holder, newProto, method.name);
    }

    private DexMethod computeFieldBridge(DexEncodedField field, boolean isGet) {
        DexType holderType = field.field.holder;
        DexType fieldType = field.field.type;
        int bridgeParameterCount = BooleanUtils.intValue(!field.isStatic()) + BooleanUtils.intValue(!isGet);
        DexType[] parameters = new DexType[bridgeParameterCount];
        if (!isGet) {
            parameters[parameters.length - 1] = fieldType;
        }
        if (!field.isStatic()) {
            parameters[0] = holderType;
        }
        DexType returnType = isGet ? fieldType : this.appView.dexItemFactory().voidType;
        DexProto proto = this.appView.dexItemFactory().createProto(returnType, parameters);
        return this.appView.dexItemFactory().createMethod(holderType, proto, this.computeFieldBridgeName(field, isGet));
    }

    boolean invokeRequiresRewriting(DexEncodedMethod method, DexClass contextClass) {
        assert (method != null);
        if (!method.accessFlags.isPrivate() || method.method.holder == contextClass.type) {
            return false;
        }
        DexClass methodHolder = this.definitionFor(method.method.holder);
        assert (methodHolder != null);
        return methodHolder.getNestHost() == contextClass.getNestHost();
    }

    boolean fieldAccessRequiresRewriting(DexEncodedField field, DexClass contextClass) {
        assert (field != null);
        if (!field.accessFlags.isPrivate() || field.field.holder == contextClass.type) {
            return false;
        }
        DexClass fieldHolder = this.definitionFor(field.field.holder);
        assert (fieldHolder != null);
        return fieldHolder.getNestHost() == contextClass.getNestHost();
    }

    private boolean holderRequiresBridge(DexClass holder) {
        if (holder.isProgramClass()) {
            return false;
        }
        if (holder.isClasspathClass()) {
            return true;
        }
        assert (holder.isLibraryClass());
        Pair<DexClass, List<DexType>> nest = this.extractNest(holder);
        assert (nest != null) : "Should be a compilation error if missing nest host on library class.";
        this.reportIncompleteNest(nest.getSecond());
        throw new Unreachable("Incomplete nest due to missing library class should raise a compilation error.");
    }

    DexMethod ensureFieldAccessBridge(DexEncodedField field, boolean isGet) {
        DexClass holder = this.definitionFor(field.field.holder);
        assert (holder != null);
        DexMethod bridgeMethod = this.computeFieldBridge(field, isGet);
        if (this.holderRequiresBridge(holder)) {
            return bridgeMethod;
        }
        Map<DexField, DexEncodedMethod> fieldMap = isGet ? this.getFieldBridges : this.putFieldBridges;
        fieldMap.computeIfAbsent(field.field, k -> DexEncodedMethod.createFieldAccessorBridge(new DexFieldWithAccess(field, isGet), holder, bridgeMethod));
        return bridgeMethod;
    }

    DexMethod ensureInvokeBridge(DexEncodedMethod method) {
        DexMethod bridgeMethod;
        DexClass holder = this.definitionFor(method.method.holder);
        assert (holder != null);
        if (method.isInstanceInitializer()) {
            this.nestConstructorUsed = true;
            bridgeMethod = this.computeInitializerBridge(method.method);
        } else {
            bridgeMethod = this.computeMethodBridge(method);
        }
        if (this.holderRequiresBridge(holder)) {
            return bridgeMethod;
        }
        this.bridges.computeIfAbsent(method.method, k -> method.isInstanceInitializer() ? method.toInitializerForwardingBridge(holder, bridgeMethod) : method.toStaticForwardingBridge(holder, this.computeMethodBridge(method)));
        return bridgeMethod;
    }

    public static final class DexFieldWithAccess {
        private final DexEncodedField field;
        private final boolean isGet;

        DexFieldWithAccess(DexEncodedField field, boolean isGet) {
            this.field = field;
            this.isGet = isGet;
        }

        public int hashCode() {
            return Objects.hash(this.field, this.isGet);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            DexFieldWithAccess other = (DexFieldWithAccess)o;
            return this.isGet == other.isGet && this.field == other.field;
        }

        public boolean isGet() {
            return this.isGet;
        }

        public boolean isStatic() {
            return this.field.accessFlags.isStatic();
        }

        public boolean isPut() {
            return !this.isGet();
        }

        public boolean isInstance() {
            return !this.isStatic();
        }

        public boolean isStaticGet() {
            return this.isStatic() && this.isGet();
        }

        public boolean isStaticPut() {
            return this.isStatic() && this.isPut();
        }

        public boolean isInstanceGet() {
            return this.isInstance() && this.isGet();
        }

        public boolean isInstancePut() {
            return this.isInstance() && this.isPut();
        }

        public DexType getType() {
            return this.field.field.type;
        }

        public DexType getHolder() {
            return this.field.field.holder;
        }

        public DexField getField() {
            return this.field.field;
        }
    }

    protected class NestBasedAccessDesugaringUseRegistry
    extends UseRegistry {
        private final DexClass currentClass;
        private DexMethod context;

        NestBasedAccessDesugaringUseRegistry(DexClass currentClass) {
            super(NestBasedAccessDesugaring.this.appView.options().itemFactory);
            this.currentClass = currentClass;
        }

        public void setContext(DexMethod context) {
            this.context = context;
        }

        private boolean registerInvoke(DexMethod method, Invoke.Type invokeType) {
            if (!method.holder.isClassType()) {
                return false;
            }
            DexEncodedMethod encodedMethod = NestBasedAccessDesugaring.this.definitionFor(method, this.context, invokeType);
            if (encodedMethod != null && NestBasedAccessDesugaring.this.invokeRequiresRewriting(encodedMethod, this.currentClass)) {
                NestBasedAccessDesugaring.this.ensureInvokeBridge(encodedMethod);
                return true;
            }
            return false;
        }

        private boolean registerFieldAccess(DexField field, boolean isGet) {
            DexEncodedField encodedField = NestBasedAccessDesugaring.this.definitionFor(field);
            if (encodedField != null && NestBasedAccessDesugaring.this.fieldAccessRequiresRewriting(encodedField, this.currentClass)) {
                NestBasedAccessDesugaring.this.ensureFieldAccessBridge(encodedField, isGet);
                return true;
            }
            return false;
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            return this.registerInvoke(method, Invoke.Type.VIRTUAL);
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            return this.registerInvoke(method, Invoke.Type.DIRECT);
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            return this.registerInvoke(method, Invoke.Type.STATIC);
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            return this.registerInvoke(method, Invoke.Type.INTERFACE);
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            return this.registerInvoke(method, Invoke.Type.SUPER);
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            return this.registerFieldAccess(field, false);
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            return this.registerFieldAccess(field, true);
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            return false;
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            return this.registerFieldAccess(field, true);
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            return this.registerFieldAccess(field, false);
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            return false;
        }
    }
}

