/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.io.UTFDataFormatException;
import java.util.List;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.AssertionsConfiguration;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.utils.AssertionConfigurationWithDefault;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.ThrowingCharIterator;

public class AssertionsRewriter {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;
    private final AssertionsConfiguration.AssertionTransformation defaultTransformation;
    private final List<ConfigurationEntryWithDexString> configuration;
    private final boolean enabled;

    public AssertionsRewriter(AppView<?> appView) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.enabled = AssertionsRewriter.isEnabled(appView.options());
        if (!this.enabled) {
            this.defaultTransformation = null;
            this.configuration = null;
            return;
        }
        this.defaultTransformation = appView.options().assertionsConfiguration.defautlTransformation;
        this.configuration = appView.options().assertionsConfiguration.assertionsConfigurations.stream().map(entry -> new ConfigurationEntryWithDexString((AssertionsConfiguration)entry, appView.dexItemFactory())).collect(Collectors.toList());
    }

    public static boolean isEnabled(InternalOptions options) {
        AssertionConfigurationWithDefault configuration = options.assertionsConfiguration;
        return configuration != null && !configuration.isPassthroughAll();
    }

    private AssertionsConfiguration.AssertionTransformation getTransformationForMethod(DexEncodedMethod method) {
        AssertionsConfiguration.AssertionTransformation transformation = this.defaultTransformation;
        block5: for (ConfigurationEntryWithDexString entry : this.configuration) {
            switch (entry.entry.getScope()) {
                case ALL: {
                    transformation = entry.entry.getTransformation();
                    continue block5;
                }
                case PACKAGE: {
                    if (((ConfigurationEntryWithDexString)entry).value.size == 0) {
                        if (method.method.holder.descriptor.contains(this.dexItemFactory.descriptorSeparator)) continue block5;
                        transformation = entry.entry.getTransformation();
                        continue block5;
                    }
                    if (!method.method.holder.descriptor.startsWith(entry.value)) continue block5;
                    transformation = entry.entry.getTransformation();
                    continue block5;
                }
                case CLASS: {
                    if (method.method.holder.descriptor.equals(entry.value)) {
                        transformation = entry.entry.getTransformation();
                    }
                    if (!this.isDescriptorForClassOrInnerClass(entry.value, method.method.holder.descriptor)) continue block5;
                    transformation = entry.entry.getTransformation();
                    continue block5;
                }
            }
            throw new Unreachable();
        }
        assert (transformation != null);
        return transformation;
    }

    private boolean isDescriptorForClassOrInnerClass(DexString classDescriptor, DexString classOrInnerClassDescriptor) {
        if (classOrInnerClassDescriptor == classDescriptor) {
            return true;
        }
        if (classOrInnerClassDescriptor.size < classDescriptor.size) {
            return false;
        }
        ThrowingCharIterator<UTFDataFormatException> i1 = classDescriptor.iterator();
        ThrowingCharIterator<UTFDataFormatException> i2 = classOrInnerClassDescriptor.iterator();
        try {
            while (i1.hasNext()) {
                char c1 = i1.nextChar();
                char c2 = i2.nextChar();
                if (c1 == ';' && c2 == '$') {
                    while (i2.hasNext()) {
                        if (i2.nextChar() != '/') continue;
                        return false;
                    }
                    return true;
                }
                if (c1 == c2) continue;
                return false;
            }
            assert (i2.hasNext());
            return false;
        }
        catch (UTFDataFormatException e) {
            return false;
        }
    }

    public void run(DexEncodedMethod method, IRCode code) {
        DexEncodedMethod clinit;
        if (!this.enabled) {
            return;
        }
        AssertionsConfiguration.AssertionTransformation transformation = this.getTransformationForMethod(method);
        if (transformation == AssertionsConfiguration.AssertionTransformation.PASSTHROUGH) {
            return;
        }
        if (method.isClassInitializer()) {
            clinit = method;
        } else {
            DexClass clazz = this.appView.definitionFor(method.method.holder);
            if (clazz == null) {
                return;
            }
            clinit = clazz.getClassInitializer();
        }
        if (clinit == null || !clinit.getOptimizationInfo().isInitializerEnablingJavaAssertions()) {
            return;
        }
        InstructionListIterator iterator2 = code.instructionListIterator();
        while (iterator2.hasNext()) {
            Instruction current = (Instruction)iterator2.next();
            if (current.isInvokeMethod()) {
                InvokeMethod invoke = current.asInvokeMethod();
                if (invoke.getInvokedMethod() != this.dexItemFactory.classMethods.desiredAssertionStatus) continue;
                iterator2.replaceCurrentInstruction(code.createIntConstant(0));
                continue;
            }
            if (current.isStaticPut()) {
                StaticPut staticPut = current.asStaticPut();
                if (staticPut.getField().name != this.dexItemFactory.assertionsDisabled) continue;
                iterator2.remove();
                continue;
            }
            if (!current.isStaticGet()) continue;
            StaticGet staticGet = current.asStaticGet();
            if (staticGet.getField().name != this.dexItemFactory.assertionsDisabled) continue;
            iterator2.replaceCurrentInstruction(code.createIntConstant(transformation == AssertionsConfiguration.AssertionTransformation.DISABLE ? 1 : 0));
        }
    }

    private static class ConfigurationEntryWithDexString {
        private AssertionsConfiguration entry;
        private final DexString value;

        private ConfigurationEntryWithDexString(AssertionsConfiguration configuration, DexItemFactory dexItemFactory) {
            this.entry = configuration;
            switch (configuration.getScope()) {
                case PACKAGE: {
                    if (configuration.getValue().length() == 0) {
                        this.value = dexItemFactory.createString("");
                        break;
                    }
                    this.value = dexItemFactory.createString("L" + configuration.getValue().replace('.', '/') + "/");
                    break;
                }
                case CLASS: {
                    this.value = dexItemFactory.createString("L" + configuration.getValue().replace('.', '/') + ";");
                    break;
                }
                case ALL: {
                    this.value = null;
                    break;
                }
                default: {
                    throw new Unreachable();
                }
            }
        }
    }
}

