/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.BitSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Assume;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.DominatorTree;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.If;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.Phi;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Assumer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.FieldOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;

public class NonNullTracker
implements Assumer {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;
    private final Consumer<BasicBlock> splitBlockConsumer;

    public NonNullTracker(AppView<?> appView) {
        this(appView, null);
    }

    public NonNullTracker(AppView<?> appView, Consumer<BasicBlock> splitBlockConsumer) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.splitBlockConsumer = splitBlockConsumer;
    }

    @Override
    public void insertAssumeInstructionsInBlocks(IRCode code, ListIterator<BasicBlock> blockIterator, Predicate<BasicBlock> blockTester) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        Set<Value> knownToBeNonNullValues = Sets.newIdentityHashSet();
        while (blockIterator.hasNext()) {
            DominatorTree dominatorTree;
            BasicBlock target;
            If theIf;
            Value knownToBeNonNullValue;
            BasicBlock block = blockIterator.next();
            if (!blockTester.test(block)) continue;
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                Object optimizationInfo;
                Value couldBeNonNull;
                Instruction current = (Instruction)iterator2.next();
                Value outValue = current.outValue();
                if (current.throwsOnNullInput() && NonNullTracker.isNullableReferenceTypeWithUsers(couldBeNonNull = current.getNonNullInput())) {
                    knownToBeNonNullValues.add(couldBeNonNull);
                }
                if (current.isInvokeMethod()) {
                    DexEncodedMethod singleTarget;
                    InvokeMethod invoke = current.asInvokeMethod();
                    DexMethod invokedMethod = invoke.getInvokedMethod();
                    if (this.dexItemFactory.libraryMethodsReturningNonNull.contains(invokedMethod) && current.hasOutValue() && NonNullTracker.isNullableReferenceTypeWithUsers(outValue)) {
                        knownToBeNonNullValues.add(outValue);
                    }
                    if ((singleTarget = invoke.lookupSingleTarget(this.appView, code.method.method.holder)) != null) {
                        BitSet nonNullParamOnNormalExits;
                        optimizationInfo = singleTarget.getOptimizationInfo();
                        if (optimizationInfo.neverReturnsNull() && invoke.hasOutValue() && NonNullTracker.isNullableReferenceTypeWithUsers(outValue)) {
                            knownToBeNonNullValues.add(outValue);
                        }
                        if ((nonNullParamOnNormalExits = optimizationInfo.getNonNullParamOnNormalExits()) != null) {
                            for (int i = 0; i < current.inValues().size(); ++i) {
                                Value value;
                                if (!nonNullParamOnNormalExits.get(i) || !NonNullTracker.isNullableReferenceTypeWithUsers(value = current.inValues().get(i))) continue;
                                knownToBeNonNullValues.add(value);
                            }
                        }
                    }
                } else if (current.isFieldGet()) {
                    DexEncodedField encodedField;
                    FieldInstruction fieldInstruction = current.asFieldInstruction();
                    DexField field = fieldInstruction.getField();
                    if (field.type.isClassType() && NonNullTracker.isNullableReferenceTypeWithUsers(outValue) && (encodedField = ((AppInfo)this.appView.appInfo()).resolveField(field)) != null && ((FieldOptimizationInfo)(optimizationInfo = encodedField.getOptimizationInfo())).getDynamicUpperBoundType() != null && ((FieldOptimizationInfo)optimizationInfo).getDynamicUpperBoundType().isDefinitelyNotNull()) {
                        knownToBeNonNullValues.add(outValue);
                    }
                }
                assert (knownToBeNonNullValues.stream().allMatch(NonNullTracker::isNullableReferenceTypeWithUsers));
                if (knownToBeNonNullValues.isEmpty()) continue;
                this.addNonNullForValues(code, blockIterator, block, iterator2, current, knownToBeNonNullValues, affectedValues);
                knownToBeNonNullValues.clear();
            }
            if (!block.exit().isIf() || !block.exit().asIf().isZeroTest() || !NonNullTracker.isNullableReferenceTypeWithUsers(knownToBeNonNullValue = (theIf = block.exit().asIf()).inValues().get(0)) || (target = theIf.targetFromNonNullObject()).isEmpty() || !(dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS)).dominatedBy(target, block)) continue;
            Set<Instruction> dominatedUsers = Sets.newIdentityHashSet();
            IdentityHashMap<Phi, IntList> dominatedPhiUsersWithPositions = new IdentityHashMap<Phi, IntList>();
            HashSet<BasicBlock> dominatedBlocks = Sets.newHashSet(dominatorTree.dominatedBlocks(target));
            for (Instruction instruction : knownToBeNonNullValue.uniqueUsers()) {
                if (!dominatedBlocks.contains(instruction.getBlock())) continue;
                dominatedUsers.add(instruction);
            }
            for (Phi phi : knownToBeNonNullValue.uniquePhiUsers()) {
                IntList dominatedPredecessorIndexes = this.findDominatedPredecessorIndexesInPhi(phi, knownToBeNonNullValue, dominatedBlocks);
                if (dominatedPredecessorIndexes.isEmpty()) continue;
                dominatedPhiUsersWithPositions.put(phi, dominatedPredecessorIndexes);
            }
            if (!knownToBeNonNullValue.isArgument() && dominatedUsers.isEmpty() && dominatedPhiUsersWithPositions.isEmpty()) continue;
            TypeLatticeElement typeLattice = knownToBeNonNullValue.getTypeLattice();
            Value value = code.createValue(typeLattice.asReferenceTypeLatticeElement().asMeetWithNotNull(), knownToBeNonNullValue.getLocalInfo());
            affectedValues.addAll(knownToBeNonNullValue.affectedValues());
            Assume<Assume.NonNullAssumption> nonNull = Assume.createAssumeNonNullInstruction(value, knownToBeNonNullValue, theIf, this.appView);
            InstructionListIterator targetIterator = target.listIterator(code);
            nonNull.setPosition(((Instruction)targetIterator.next()).getPosition());
            targetIterator.previous();
            targetIterator.add(nonNull);
            knownToBeNonNullValue.replaceSelectiveUsers(value, dominatedUsers, dominatedPhiUsersWithPositions);
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
    }

    private void addNonNullForValues(IRCode code, ListIterator<BasicBlock> blockIterator, BasicBlock block, InstructionListIterator iterator2, Instruction current, Set<Value> knownToBeNonNullValues, Set<Value> affectedValues) {
        BasicBlock blockWithNonNullInstruction;
        boolean split = block.hasCatchHandlers();
        if (split) {
            blockWithNonNullInstruction = iterator2.split(code, blockIterator);
            if (this.splitBlockConsumer != null) {
                this.splitBlockConsumer.accept(blockWithNonNullInstruction);
            }
        } else {
            blockWithNonNullInstruction = block;
        }
        DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
        for (Value knownToBeNonNullValue : knownToBeNonNullValues) {
            Set<Instruction> users = knownToBeNonNullValue.uniqueUsers();
            Set<Instruction> dominatedUsers = Sets.newIdentityHashSet();
            IdentityHashMap<Phi, IntList> dominatedPhiUsersWithPositions = new IdentityHashMap<Phi, IntList>();
            Set<BasicBlock> dominatedBlocks = Sets.newIdentityHashSet();
            for (BasicBlock dominatee : dominatorTree.dominatedBlocks(blockWithNonNullInstruction)) {
                dominatedBlocks.add(dominatee);
                InstructionIterator dominateeIterator = dominatee.iterator();
                if (dominatee == blockWithNonNullInstruction && !split) {
                    dominateeIterator.nextUntil(instruction -> instruction == current);
                }
                while (dominateeIterator.hasNext()) {
                    Instruction potentialUser = (Instruction)dominateeIterator.next();
                    if (!users.contains(potentialUser)) continue;
                    dominatedUsers.add(potentialUser);
                }
            }
            for (Phi user : knownToBeNonNullValue.uniquePhiUsers()) {
                IntList dominatedPredecessorIndexes = this.findDominatedPredecessorIndexesInPhi(user, knownToBeNonNullValue, dominatedBlocks);
                if (dominatedPredecessorIndexes.isEmpty()) continue;
                dominatedPhiUsersWithPositions.put(user, dominatedPredecessorIndexes);
            }
            if (!knownToBeNonNullValue.isArgument() && dominatedUsers.isEmpty() && dominatedPhiUsersWithPositions.isEmpty()) continue;
            TypeLatticeElement typeLattice = knownToBeNonNullValue.getTypeLattice();
            assert (typeLattice.isReference());
            Value nonNullValue = code.createValue(typeLattice.asReferenceTypeLatticeElement().asMeetWithNotNull(), knownToBeNonNullValue.getLocalInfo());
            affectedValues.addAll(knownToBeNonNullValue.affectedValues());
            Assume<Assume.NonNullAssumption> nonNull = Assume.createAssumeNonNullInstruction(nonNullValue, knownToBeNonNullValue, current, this.appView);
            nonNull.setPosition(current.getPosition());
            if (blockWithNonNullInstruction != block) {
                blockWithNonNullInstruction.listIterator(code).add(nonNull);
            } else {
                iterator2.add(nonNull);
            }
            knownToBeNonNullValue.replaceSelectiveUsers(nonNullValue, dominatedUsers, dominatedPhiUsersWithPositions);
        }
    }

    private IntList findDominatedPredecessorIndexesInPhi(Phi user, Value knownToBeNonNullValue, Set<BasicBlock> dominatedBlocks) {
        assert (user.getOperands().contains(knownToBeNonNullValue));
        List<Value> operands = user.getOperands();
        List<BasicBlock> predecessors = user.getBlock().getPredecessors();
        assert (operands.size() == predecessors.size());
        IntArrayList predecessorIndexes = new IntArrayList();
        int index = 0;
        Iterator<Value> operandIterator = operands.iterator();
        Iterator<BasicBlock> predecessorIterator = predecessors.iterator();
        while (operandIterator.hasNext() && predecessorIterator.hasNext()) {
            Value operand = operandIterator.next();
            BasicBlock predecessor = predecessorIterator.next();
            if (operand == knownToBeNonNullValue && dominatedBlocks.contains(predecessor)) {
                predecessorIndexes.add(index);
            }
            ++index;
        }
        return predecessorIndexes;
    }

    private static boolean isNullableReferenceTypeWithUsers(Value value) {
        TypeLatticeElement type = value.getTypeLattice();
        return type.isReference() && type.asReferenceTypeLatticeElement().isNullable() && value.numberOfAllUsers() > 0;
    }
}

