/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.staticizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Lists;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.KeyedDexItem;
import shadow.bundletool.com.android.tools.r8.graph.UseRegistry;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeDirect;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeStatic;
import shadow.bundletool.com.android.tools.r8.ir.code.NewInstance;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticPut;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRConverter;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import shadow.bundletool.com.android.tools.r8.ir.optimize.staticizer.StaticizingProcessor;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.ListUtils;

public final class ClassStaticizer {
    private final AppView<AppInfoWithLiveness> appView;
    private final DexItemFactory factory;
    private final IRConverter converter;
    final ConcurrentHashMap<DexType, CandidateInfo> candidates = new ConcurrentHashMap();

    public ClassStaticizer(AppView<AppInfoWithLiveness> appView, IRConverter converter) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.converter = converter;
    }

    public final void collectCandidates(DexApplication app) {
        Set notEligible = Sets.newIdentityHashSet();
        HashMap singletonFields = new HashMap();
        app.classes().forEach(cls -> {
            Iterator<KeyedDexItem> iterator2 = cls.staticFields().iterator();
            while (iterator2.hasNext()) {
                DexEncodedField field;
                DexType type = field.field.type;
                field = iterator2.next();
                if (singletonFields.put(type, field) == null) continue;
                notEligible.add(type);
            }
            for (DexEncodedField field : cls.instanceFields()) {
                notEligible.add(field.field.type);
            }
            for (DexEncodedMethod method : cls.methods()) {
                DexProto proto = method.method.proto;
                notEligible.addAll(Arrays.asList(proto.parameters.values));
            }
            if (cls.isInterface() || cls.accessFlags.isAbstract() || cls.instanceFields().size() > 0 || cls.superType != this.factory.objectType || this.appView.appInfo().hasSubtypes(cls.type) || !cls.interfaces.isEmpty()) {
                notEligible.add(cls.type);
            }
        });
        app.classes().forEach(cls -> {
            DexEncodedField field;
            DexType type = cls.type;
            if (!(notEligible.contains(type) || (field = (DexEncodedField)singletonFields.get(type)) == null || field.accessFlags.isVolatile() || this.isPinned((DexClass)cls, field))) {
                assert (field.accessFlags.isStatic());
                new CandidateInfo((DexProgramClass)cls, field);
            }
        });
    }

    private boolean isPinned(DexClass clazz, DexEncodedField singletonField) {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        if (appInfo.isPinned(clazz.type) || appInfo.isPinned(singletonField.field)) {
            return true;
        }
        for (DexEncodedMethod method : clazz.methods()) {
            if (method.isStatic() || !appInfo.isPinned(method.method)) continue;
            return true;
        }
        return false;
    }

    public final void examineMethodCode(DexEncodedMethod method, IRCode code) {
        Set<Instruction> alreadyProcessed = Sets.newIdentityHashSet();
        CandidateInfo receiverClassCandidateInfo = this.candidates.get(method.method.holder);
        Value receiverValue = code.getThis();
        if (receiverClassCandidateInfo != null) {
            if (receiverValue != null) {
                this.analyzeAllValueUsers(receiverClassCandidateInfo, receiverValue, this.factory.isConstructor(method.method));
                if (this.candidates.get(method.method.holder) != null) {
                    alreadyProcessed.addAll(receiverValue.uniqueUsers());
                }
            } else if (method.method.proto.returnType == method.method.holder) {
                List<Instruction> examined = this.isValidGetter(receiverClassCandidateInfo, code);
                if (examined != null) {
                    DexEncodedMethod getter = receiverClassCandidateInfo.getter.get();
                    if (getter == null) {
                        receiverClassCandidateInfo.getter.set(method);
                        alreadyProcessed.addAll(examined);
                    } else {
                        assert (getter != method);
                        receiverClassCandidateInfo.invalidate();
                    }
                } else {
                    receiverClassCandidateInfo.invalidate();
                }
            }
        }
        ListIterator<Instruction> iterator2 = Lists.newArrayList(code.instructionIterator()).listIterator();
        while (iterator2.hasNext()) {
            Value value;
            CandidateInfo info;
            CandidateInfo candidateInfo;
            Instruction instruction = iterator2.next();
            if (alreadyProcessed.contains(instruction)) continue;
            if (instruction.isNewInstance()) {
                NewInstance newInstance = instruction.asNewInstance();
                candidateInfo = this.processInstantiation(method, iterator2, newInstance);
                if (candidateInfo == null) continue;
                while (iterator2.hasNext()) {
                    if (this.isAllowedInHostClassInitializer(method.method.holder, iterator2.next(), code)) continue;
                    candidateInfo.preserveRead.set(true);
                    iterator2.previous();
                    break;
                }
                candidateInfo.referencedFrom.add(method);
                continue;
            }
            if (instruction.isStaticPut()) {
                DexType candidateType = instruction.asStaticPut().getField().type;
                candidateInfo = this.candidates.get(candidateType);
                if (candidateInfo == null) continue;
                candidateInfo.invalidate();
                continue;
            }
            if (instruction.isStaticGet()) {
                info = this.processStaticFieldRead(instruction.asStaticGet());
                if (info == null) continue;
                info.referencedFrom.add(method);
                value = instruction.outValue();
                if (value == null) continue;
                alreadyProcessed.addAll(value.aliasedUsers());
                continue;
            }
            if (instruction.isInvokeStatic()) {
                info = this.processInvokeStatic(instruction.asInvokeStatic());
                if (info == null) continue;
                info.referencedFrom.add(method);
                value = instruction.outValue();
                if (value == null) continue;
                alreadyProcessed.addAll(value.aliasedUsers());
                continue;
            }
            if (instruction.isInvokeMethodWithReceiver()) {
                DexMethod invokedMethod = instruction.asInvokeMethodWithReceiver().getInvokedMethod();
                candidateInfo = this.candidates.get(invokedMethod.holder);
                if (candidateInfo == null) continue;
                candidateInfo.invalidate();
                continue;
            }
            if (instruction.isInvokeCustom()) {
                CallSiteReferencesInvalidator invalidator = new CallSiteReferencesInvalidator(this.factory);
                invalidator.registerCallSite(instruction.asInvokeCustom().getCallSite());
                continue;
            }
            if (!instruction.isInstanceGet() && !instruction.isInstancePut()) continue;
            DexField fieldReferenced = instruction.asFieldInstruction().getField();
            candidateInfo = this.candidates.get(fieldReferenced.holder);
            if (candidateInfo == null) continue;
            candidateInfo.invalidate();
        }
    }

    private boolean isAllowedInHostClassInitializer(DexType host, Instruction insn, IRCode code) {
        return insn.isStaticPut() && insn.asStaticPut().getField().holder == host || insn.isConstNumber() || insn.isConstString() || insn.isGoto() && insn.asGoto().isTrivialGotoToTheNextBlock(code) || insn.isReturn();
    }

    private CandidateInfo processInstantiation(DexEncodedMethod method, ListIterator<Instruction> iterator2, NewInstance newInstance) {
        DexType candidateType = newInstance.clazz;
        CandidateInfo candidateInfo = this.candidates.get(candidateType);
        if (candidateInfo == null) {
            return null;
        }
        if (iterator2.previousIndex() != 0) {
            return candidateInfo.invalidate();
        }
        if (!candidateInfo.isHostClassInitializer(method)) {
            return candidateInfo.invalidate();
        }
        if (candidateInfo.instancesCreated.incrementAndGet() > 1) {
            return candidateInfo.invalidate();
        }
        Value candidateValue = newInstance.dest();
        if (candidateValue == null) {
            return candidateInfo.invalidate();
        }
        if (candidateValue.numberOfPhiUsers() > 0) {
            return candidateInfo.invalidate();
        }
        if (candidateValue.numberOfUsers() != 2) {
            return candidateInfo.invalidate();
        }
        while (iterator2.hasNext() && this.isNonThrowingConstInstruction(iterator2.next())) {
        }
        iterator2.previous();
        if (!iterator2.hasNext()) {
            return candidateInfo.invalidate();
        }
        if (!this.isValidInitCall(candidateInfo, iterator2.next(), candidateValue, candidateType)) {
            iterator2.previous();
            return candidateInfo.invalidate();
        }
        if (!iterator2.hasNext()) {
            return candidateInfo.invalidate();
        }
        if (!this.isValidStaticPut(candidateInfo, iterator2.next())) {
            iterator2.previous();
            return candidateInfo.invalidate();
        }
        if (candidateInfo.fieldWrites.incrementAndGet() > 1) {
            return candidateInfo.invalidate();
        }
        return candidateInfo;
    }

    private boolean isNonThrowingConstInstruction(Instruction instruction) {
        return instruction.isConstInstruction() && !instruction.instructionTypeCanThrow();
    }

    private boolean isValidInitCall(CandidateInfo info, Instruction instruction, Value candidateValue, DexType candidateType) {
        if (!instruction.isInvokeDirect()) {
            return false;
        }
        InvokeDirect invoke = instruction.asInvokeDirect();
        DexEncodedMethod methodInvoked = this.appView.appInfo().lookupDirectTarget(invoke.getInvokedMethod());
        List<Value> values2 = invoke.inValues();
        if (ListUtils.lastIndexMatching(values2, v -> v.getAliasedValue() == candidateValue) != 0 || methodInvoked == null || methodInvoked.method.holder != candidateType) {
            return false;
        }
        for (int i = 1; i < values2.size(); ++i) {
            Value arg = values2.get(i).getAliasedValue();
            if (!arg.isPhi() && arg.definition.isConstInstruction()) continue;
            return false;
        }
        DexEncodedMethod previous = info.constructor.getAndSet(methodInvoked);
        assert (previous == null);
        return true;
    }

    private boolean isValidStaticPut(CandidateInfo info, Instruction instruction) {
        if (!instruction.isStaticPut()) {
            return false;
        }
        StaticPut staticPut = instruction.asStaticPut();
        DexEncodedField fieldAccessed = this.appView.appInfo().lookupStaticTarget(staticPut.getField().holder, staticPut.getField());
        return fieldAccessed == info.singletonField;
    }

    private List<Instruction> isValidGetter(CandidateInfo info, IRCode code) {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        StaticGet staticGet = null;
        for (Instruction instr : code.instructions()) {
            if (instr.isStaticGet()) {
                staticGet = instr.asStaticGet();
                DexEncodedField fieldAccessed = this.appView.appInfo().lookupStaticTarget(staticGet.getField().holder, staticGet.getField());
                if (fieldAccessed != info.singletonField) {
                    return null;
                }
                instructions.add(instr);
                continue;
            }
            if (instr.isAssume() || instr.isReturn()) {
                Value v = instr.inValues().get(0).getAliasedValue();
                if (v.isPhi() || v.definition != staticGet) {
                    return null;
                }
                instructions.add(instr);
                continue;
            }
            return null;
        }
        return instructions;
    }

    private CandidateInfo processStaticFieldRead(StaticGet staticGet) {
        DexField field = staticGet.getField();
        DexType candidateType = field.type;
        CandidateInfo candidateInfo = this.candidates.get(candidateType);
        if (candidateInfo == null) {
            return null;
        }
        assert (candidateInfo.singletonField == this.appView.appInfo().lookupStaticTarget(field.holder, field)) : "Added reference after collectCandidates(...)?";
        Value singletonValue = staticGet.dest();
        if (singletonValue != null) {
            candidateInfo = this.analyzeAllValueUsers(candidateInfo, singletonValue, false);
        }
        return candidateInfo;
    }

    private CandidateInfo processInvokeStatic(InvokeStatic invoke) {
        DexType candidateType = invoke.getInvokedMethod().proto.returnType;
        CandidateInfo candidateInfo = this.candidates.get(candidateType);
        if (candidateInfo == null) {
            return null;
        }
        if (invoke.hasOutValue() && candidateInfo.getter.get() != null && candidateInfo.getter.get().method == invoke.getInvokedMethod()) {
            candidateInfo = this.analyzeAllValueUsers(candidateInfo, invoke.outValue(), false);
        }
        return candidateInfo;
    }

    private CandidateInfo analyzeAllValueUsers(CandidateInfo candidateInfo, Value value, boolean ignoreSuperClassInitInvoke) {
        assert (value != null && value == value.getAliasedValue());
        if (value.numberOfPhiUsers() > 0) {
            return candidateInfo.invalidate();
        }
        Set<Instruction> currentUsers = value.uniqueUsers();
        while (!currentUsers.isEmpty()) {
            Set<Instruction> indirectUsers = Sets.newIdentityHashSet();
            for (Instruction user : currentUsers) {
                if (user.isAssume()) {
                    if (user.outValue().numberOfPhiUsers() > 0) {
                        return candidateInfo.invalidate();
                    }
                    indirectUsers.addAll(user.outValue().uniqueUsers());
                    continue;
                }
                if (user.isInvokeVirtual() || user.isInvokeDirect()) {
                    DexEncodedMethod methodInvoked;
                    InvokeMethodWithReceiver invoke = user.asInvokeMethodWithReceiver();
                    Predicate<Value> isAliasedValue = v -> v.getAliasedValue() == value;
                    DexMethod methodReferenced = invoke.getInvokedMethod();
                    if (this.factory.isConstructor(methodReferenced)) {
                        assert (user.isInvokeDirect());
                        if (ignoreSuperClassInitInvoke && ListUtils.lastIndexMatching(invoke.inValues(), isAliasedValue) == 0 && methodReferenced == this.factory.objectMethods.constructor) continue;
                        return candidateInfo.invalidate();
                    }
                    AppInfoWithLiveness appInfo = this.appView.appInfo();
                    DexEncodedMethod dexEncodedMethod = methodInvoked = user.isInvokeDirect() ? appInfo.lookupDirectTarget(methodReferenced) : appInfo.lookupVirtualTarget(methodReferenced.holder, methodReferenced);
                    if (ListUtils.lastIndexMatching(invoke.inValues(), isAliasedValue) == 0 && methodInvoked != null && methodInvoked.method.holder == candidateInfo.candidate.type) continue;
                }
                return candidateInfo.invalidate();
            }
            currentUsers = indirectUsers;
        }
        return candidateInfo;
    }

    public final void staticizeCandidates(OptimizationFeedback feedback, ExecutorService executorService) throws ExecutionException {
        new StaticizingProcessor(this.appView, this, this.converter).run(feedback, executorService);
    }

    private class CallSiteReferencesInvalidator
    extends UseRegistry {
        private CallSiteReferencesInvalidator(DexItemFactory factory) {
            super(factory);
        }

        private boolean registerMethod(DexMethod method) {
            this.registerTypeReference(method.holder);
            this.registerProto(method.proto);
            return true;
        }

        private boolean registerField(DexField field) {
            this.registerTypeReference(field.holder);
            this.registerTypeReference(field.type);
            return true;
        }

        @Override
        public boolean registerInvokeVirtual(DexMethod method) {
            return this.registerMethod(method);
        }

        @Override
        public boolean registerInvokeDirect(DexMethod method) {
            return this.registerMethod(method);
        }

        @Override
        public boolean registerInvokeStatic(DexMethod method) {
            return this.registerMethod(method);
        }

        @Override
        public boolean registerInvokeInterface(DexMethod method) {
            return this.registerMethod(method);
        }

        @Override
        public boolean registerInvokeSuper(DexMethod method) {
            return this.registerMethod(method);
        }

        @Override
        public boolean registerInstanceFieldWrite(DexField field) {
            return this.registerField(field);
        }

        @Override
        public boolean registerInstanceFieldRead(DexField field) {
            return this.registerField(field);
        }

        @Override
        public boolean registerNewInstance(DexType type) {
            return this.registerTypeReference(type);
        }

        @Override
        public boolean registerStaticFieldRead(DexField field) {
            return this.registerField(field);
        }

        @Override
        public boolean registerStaticFieldWrite(DexField field) {
            return this.registerField(field);
        }

        @Override
        public boolean registerTypeReference(DexType type) {
            CandidateInfo candidateInfo = ClassStaticizer.this.candidates.get(type);
            if (candidateInfo != null) {
                candidateInfo.invalidate();
            }
            return true;
        }
    }

    final class CandidateInfo {
        final DexProgramClass candidate;
        final DexEncodedField singletonField;
        final AtomicBoolean preserveRead = new AtomicBoolean(false);
        final AtomicInteger fieldWrites = new AtomicInteger();
        final AtomicInteger instancesCreated = new AtomicInteger();
        final Set<DexEncodedMethod> referencedFrom = Sets.newConcurrentHashSet();
        final AtomicReference<DexEncodedMethod> constructor = new AtomicReference();
        final AtomicReference<DexEncodedMethod> getter = new AtomicReference();

        CandidateInfo(DexProgramClass candidate, DexEncodedField singletonField) {
            assert (candidate != null);
            assert (singletonField != null);
            this.candidate = candidate;
            this.singletonField = singletonField;
            ClassStaticizer.this.candidates.put(candidate.type, this);
        }

        boolean isHostClassInitializer(DexEncodedMethod method) {
            return ClassStaticizer.this.factory.isClassConstructor(method.method) && method.method.holder == this.hostType();
        }

        DexType hostType() {
            return this.singletonField.field.holder;
        }

        DexClass hostClass() {
            DexClass hostClass = ClassStaticizer.this.appView.definitionFor(this.hostType());
            assert (hostClass != null);
            return hostClass;
        }

        CandidateInfo invalidate() {
            ClassStaticizer.this.candidates.remove(this.candidate.type);
            return null;
        }
    }
}

