/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.kotlin;

import java.util.Arrays;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmConstructor;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmConstructorExtensionVisitor;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmConstructorVisitor;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmExtensionType;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunction;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunctionExtensionVisitor;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunctionVisitor;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmProperty;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmPropertyExtensionVisitor;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmPropertyVisitor;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmConstructorExtensionVisitor;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmFieldSignature;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmFunctionExtensionVisitor;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmMethodSignature;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.JvmPropertyExtensionVisitor;

class KotlinMetadataJvmExtensionUtils {
    KotlinMetadataJvmExtensionUtils() {
    }

    private static boolean isValidJvmMethodSignature(String desc) {
        return desc != null && !desc.isEmpty() && desc.charAt(0) == '(' && desc.lastIndexOf(40) == 0 && desc.indexOf(41) != -1 && desc.indexOf(41) == desc.lastIndexOf(41) && desc.lastIndexOf(41) < desc.length();
    }

    static String returnTypeFromJvmMethodSignature(JvmMethodSignature signature) {
        if (signature == null) {
            return null;
        }
        String desc = signature.getDesc();
        if (!KotlinMetadataJvmExtensionUtils.isValidJvmMethodSignature(desc)) {
            return null;
        }
        int index = desc.lastIndexOf(41);
        assert (desc.charAt(0) == '(' && 0 < index && index < desc.length()) : signature.asString();
        return desc.substring(index + 1);
    }

    static List<String> parameterTypesFromJvmMethodSignature(JvmMethodSignature signature) {
        if (signature == null) {
            return null;
        }
        String desc = signature.getDesc();
        if (!KotlinMetadataJvmExtensionUtils.isValidJvmMethodSignature(desc)) {
            return null;
        }
        int index = desc.lastIndexOf(41);
        assert (desc.charAt(0) == '(' && 0 < index && index < desc.length()) : signature.asString();
        String params = desc.substring(1, index);
        if (params.isEmpty()) {
            return ImmutableList.of();
        }
        return Arrays.asList(params.split(","));
    }

    static class KmPropertyProcessor {
        private JvmFieldSignature fieldSignature = null;
        private JvmMethodSignature getterSignature = null;
        private JvmMethodSignature setterSignature = null;

        KmPropertyProcessor(KmProperty kmProperty) {
            kmProperty.accept(new KmPropertyVisitor(){

                @Override
                public KmPropertyExtensionVisitor visitExtensions(KmExtensionType type) {
                    if (type != JvmPropertyExtensionVisitor.TYPE) {
                        return null;
                    }
                    return new JvmPropertyExtensionVisitor(){

                        @Override
                        public void visit(int flags, JvmFieldSignature fieldDesc, JvmMethodSignature getterDesc, JvmMethodSignature setterDesc) {
                            assert (fieldSignature == null) : KmPropertyProcessor.access$200(this).asString();
                            fieldSignature = fieldDesc;
                            assert (getterSignature == null) : KmPropertyProcessor.access$300(this).asString();
                            getterSignature = getterDesc;
                            assert (setterSignature == null) : KmPropertyProcessor.access$400(this).asString();
                            setterSignature = setterDesc;
                        }
                    };
                }
            });
        }

        JvmFieldSignature fieldSignature() {
            return this.fieldSignature;
        }

        JvmMethodSignature getterSignature() {
            return this.getterSignature;
        }

        JvmMethodSignature setterSignature() {
            return this.setterSignature;
        }
    }

    static class KmFunctionProcessor {
        private JvmMethodSignature signature = null;

        KmFunctionProcessor(KmFunction kmFunction) {
            kmFunction.accept(new KmFunctionVisitor(){

                @Override
                public KmFunctionExtensionVisitor visitExtensions(KmExtensionType type) {
                    if (type != JvmFunctionExtensionVisitor.TYPE) {
                        return null;
                    }
                    return new JvmFunctionExtensionVisitor(){

                        @Override
                        public void visit(JvmMethodSignature desc) {
                            assert (signature == null) : KmFunctionProcessor.access$100(this).asString();
                            signature = desc;
                        }
                    };
                }
            });
        }

        JvmMethodSignature signature() {
            return this.signature;
        }
    }

    static class KmConstructorProcessor {
        private JvmMethodSignature signature = null;

        KmConstructorProcessor(KmConstructor kmConstructor) {
            kmConstructor.accept(new KmConstructorVisitor(){

                @Override
                public KmConstructorExtensionVisitor visitExtensions(KmExtensionType type) {
                    if (type != JvmConstructorExtensionVisitor.TYPE) {
                        return null;
                    }
                    return new JvmConstructorExtensionVisitor(){

                        @Override
                        public void visit(JvmMethodSignature desc) {
                            assert (signature == null) : KmConstructorProcessor.access$000(this).asString();
                            signature = desc;
                        }
                    };
                }
            });
        }

        JvmMethodSignature signature() {
            return this.signature;
        }
    }
}

