/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.kotlin;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationElement;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassHeader;
import shadow.bundletool.com.android.tools.r8.kotlin.Kotlin;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinInfo;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.ThreadUtils;

public class KotlinMetadataRewriter {
    private final AppView<AppInfoWithLiveness> appView;
    private final NamingLens lens;
    private final DexItemFactory factory;
    private final Kotlin kotlin;

    public KotlinMetadataRewriter(AppView<AppInfoWithLiveness> appView, NamingLens lens) {
        this.appView = appView;
        this.lens = lens;
        this.factory = appView.dexItemFactory();
        this.kotlin = this.factory.kotlin;
    }

    public static void removeKotlinMetadataFromRenamedClass(AppView<?> appView, DexType type) {
        DexClass clazz = appView.definitionFor(type);
        if (clazz == null) {
            return;
        }
        KotlinMetadataRewriter.removeKotlinMetadataFromRenamedClass(appView, clazz);
    }

    public static void removeKotlinMetadataFromRenamedClass(AppView<?> appView, DexClass clazz) {
        clazz.annotations = clazz.annotations.keepIf(anno -> KotlinMetadataRewriter.isNotKotlinMetadata(appView, anno));
        if (clazz.isProgramClass()) {
            clazz.asProgramClass().setKotlinInfo(null);
        }
    }

    private static boolean isNotKotlinMetadata(AppView<?> appView, DexAnnotation annotation) {
        return annotation.annotation.type != appView.dexItemFactory().kotlin.metadata.kotlinMetadataType;
    }

    public void run(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(this.appView.appInfo().classes(), clazz -> {
            KotlinInfo kotlinInfo = clazz.getKotlinInfo();
            if (kotlinInfo != null) {
                assert (this.lens.lookupType(clazz.type, this.appView.dexItemFactory()) == clazz.type) : clazz.toSourceString() + " != " + this.lens.lookupType(clazz.type, this.appView.dexItemFactory());
                DexAnnotation oldMeta = clazz.annotations.getFirstMatching(this.kotlin.metadata.kotlinMetadataType);
                if (oldMeta == null) {
                    return;
                }
                kotlinInfo.rewrite(this.appView, this.lens);
                DexAnnotation newMeta = this.createKotlinMetadataAnnotation(kotlinInfo.createHeader());
                clazz.annotations = clazz.annotations.rewrite(anno -> anno == oldMeta ? newMeta : anno);
            }
        }, executorService);
    }

    private DexAnnotation createKotlinMetadataAnnotation(KotlinClassHeader header) {
        ArrayList<DexAnnotationElement> elements = new ArrayList<DexAnnotationElement>();
        elements.add(new DexAnnotationElement(this.kotlin.metadata.kind, DexValue.DexValueInt.create(header.getKind())));
        elements.add(new DexAnnotationElement(this.kotlin.metadata.metadataVersion, this.createIntArray(header.getMetadataVersion())));
        elements.add(new DexAnnotationElement(this.kotlin.metadata.bytecodeVersion, this.createIntArray(header.getBytecodeVersion())));
        elements.add(new DexAnnotationElement(this.kotlin.metadata.data1, this.createStringArray(header.getData1())));
        elements.add(new DexAnnotationElement(this.kotlin.metadata.data2, this.createStringArray(header.getData2())));
        elements.add(new DexAnnotationElement(this.kotlin.metadata.extraString, new DexValue.DexValueString(this.factory.createString(header.getExtraString()))));
        elements.add(new DexAnnotationElement(this.kotlin.metadata.packageName, new DexValue.DexValueString(this.factory.createString(header.getPackageName()))));
        elements.add(new DexAnnotationElement(this.kotlin.metadata.extraInt, DexValue.DexValueInt.create(header.getExtraInt())));
        DexEncodedAnnotation encodedAnnotation = new DexEncodedAnnotation(this.kotlin.metadata.kotlinMetadataType, elements.toArray(DexAnnotationElement.EMPTY_ARRAY));
        return new DexAnnotation(1, encodedAnnotation);
    }

    private DexValue.DexValueArray createIntArray(int[] data2) {
        DexValue[] values2 = new DexValue[data2.length];
        for (int i = 0; i < data2.length; ++i) {
            values2[i] = DexValue.DexValueInt.create(data2[i]);
        }
        return new DexValue.DexValueArray(values2);
    }

    private DexValue.DexValueArray createStringArray(String[] data2) {
        DexValue[] values2 = new DexValue[data2.length];
        for (int i = 0; i < data2.length; ++i) {
            values2[i] = new DexValue.DexValueString(this.factory.createString(data2[i]));
        }
        return new DexValue.DexValueArray(values2);
    }
}

