/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.position.Position;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

public class ApplyMappingError
extends StringDiagnostic {
    private static final String EXISTING_MESSAGE_START = "'%s' cannot be mapped to '%s' because it is in conflict with an existing ";
    private static final String EXISTING_MESSAGE_END = ". This usually happens when compiling a test application against a source application and having short generic names in the test application. Try giving '%s' a more specific name or add a keep rule to keep '%s'.";
    protected static final String EXISTING_CLASS_MESSAGE = "'%s' cannot be mapped to '%s' because it is in conflict with an existing class with the same name. This usually happens when compiling a test application against a source application and having short generic names in the test application. Try giving '%s' a more specific name or add a keep rule to keep '%s'.";
    protected static final String EXISTING_MEMBER_MESSAGE = "'%s' cannot be mapped to '%s' because it is in conflict with an existing member with the same signature. This usually happens when compiling a test application against a source application and having short generic names in the test application. Try giving '%s' a more specific name or add a keep rule to keep '%s'.";

    private ApplyMappingError(String message, Position position) {
        super(message, Origin.unknown(), position);
    }

    static ApplyMappingError mapToExistingClass(String originalName, String renamedName, Position position) {
        return new ApplyMappingError(String.format(EXISTING_CLASS_MESSAGE, originalName, renamedName, renamedName, originalName), position);
    }

    static ApplyMappingError mapToExistingMember(String originalName, String renamedName, Position position) {
        return new ApplyMappingError(String.format(EXISTING_MEMBER_MESSAGE, originalName, renamedName, renamedName, originalName), position);
    }
}

