/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.Type;
import shadow.bundletool.com.android.tools.r8.position.Position;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class MemberNaming {
    final Signature signature;
    final Signature renamedSignature;
    final Position position;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemberNaming)) {
            return false;
        }
        MemberNaming that = (MemberNaming)o;
        return this.signature.equals(that.signature) && this.renamedSignature.equals(that.renamedSignature);
    }

    public int hashCode() {
        int result = this.signature.hashCode();
        result = 31 * result + this.renamedSignature.hashCode();
        return result;
    }

    public MemberNaming(Signature signature, String renamedName) {
        this(signature, renamedName, Position.UNKNOWN);
    }

    public MemberNaming(Signature signature, String renamedName, Position position) {
        this.signature = signature;
        this.renamedSignature = signature.asRenamed(renamedName);
        this.position = position;
    }

    public Signature getOriginalSignature() {
        return this.signature;
    }

    public String getOriginalName() {
        return this.signature.name;
    }

    public Signature getRenamedSignature() {
        return this.renamedSignature;
    }

    public String getRenamedName() {
        return this.renamedSignature.name;
    }

    public boolean isMethodNaming() {
        return this.signature.kind() == Signature.SignatureKind.METHOD;
    }

    public boolean isFieldNaming() {
        return this.signature.kind() == Signature.SignatureKind.FIELD;
    }

    public Position getPosition() {
        return this.position;
    }

    public String toString() {
        return this.signature.toString() + " -> " + this.renamedSignature.name;
    }

    public static class MethodSignature
    extends Signature {
        public final String type;
        public final String[] parameters;

        public MethodSignature(String name, String type, String[] parameters) {
            super(name);
            this.type = type;
            this.parameters = parameters;
        }

        public MethodSignature(String name, String type, Collection<String> parameters) {
            super(name);
            this.type = type;
            this.parameters = parameters.toArray(StringUtils.EMPTY_ARRAY);
        }

        public static MethodSignature fromDexMethod(DexMethod method) {
            return MethodSignature.fromDexMethod(method, false);
        }

        public static MethodSignature fromDexMethod(DexMethod method, boolean withQualifiedName) {
            String[] paramNames = new String[method.getArity()];
            DexType[] values2 = method.proto.parameters.values;
            for (int i = 0; i < values2.length; ++i) {
                paramNames[i] = values2[i].toSourceString();
            }
            return new MethodSignature(withQualifiedName ? method.qualifiedName() : method.name.toSourceString(), method.proto.returnType.toSourceString(), paramNames);
        }

        public static MethodSignature fromSignature(String name, String signature) {
            Type[] parameterDescriptors = Type.getArgumentTypes(signature);
            Type returnDescriptor = Type.getReturnType(signature);
            String[] parameterTypes = new String[parameterDescriptors.length];
            for (int i = 0; i < parameterDescriptors.length; ++i) {
                parameterTypes[i] = DescriptorUtils.descriptorToJavaType(parameterDescriptors[i].getDescriptor());
            }
            return new MethodSignature(name, DescriptorUtils.descriptorToJavaType(returnDescriptor.getDescriptor()), parameterTypes);
        }

        public MethodSignature toUnqualified() {
            assert (this.isQualified());
            return new MethodSignature(this.toUnqualifiedName(), this.type, this.parameters);
        }

        public DexMethod toDexMethod(DexItemFactory factory, DexType clazz) {
            DexType[] paramTypes = new DexType[this.parameters.length];
            for (int i = 0; i < this.parameters.length; ++i) {
                paramTypes[i] = factory.createType(DescriptorUtils.javaTypeToDescriptor(this.parameters[i]));
            }
            DexType returnType = factory.createType(DescriptorUtils.javaTypeToDescriptor(this.type));
            return factory.createMethod(clazz, factory.createProto(returnType, paramTypes), factory.createString(this.name));
        }

        public static MethodSignature initializer(String[] parameters) {
            return new MethodSignature("<init>", "void", parameters);
        }

        @Override
        Signature asRenamed(String renamedName) {
            return new MethodSignature(renamedName, this.type, this.parameters);
        }

        @Override
        public Signature.SignatureKind kind() {
            return Signature.SignatureKind.METHOD;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodSignature)) {
                return false;
            }
            MethodSignature that = (MethodSignature)o;
            return this.type.equals(that.type) && this.name.equals(that.name) && Arrays.equals(this.parameters, that.parameters);
        }

        @Override
        public int hashCode() {
            return (this.type.hashCode() * 17 + this.name.hashCode()) * 31 + Arrays.hashCode(this.parameters);
        }

        @Override
        public String toString() {
            return this.type + ' ' + this.name + '(' + String.join((CharSequence)",", this.parameters) + ')';
        }

        @Override
        void write(Writer writer) throws IOException {
            writer.append(this.type).append(' ').append(this.name).append('(');
            for (int i = 0; i < this.parameters.length; ++i) {
                writer.append(this.parameters[i]);
                if (i >= this.parameters.length - 1) continue;
                writer.append(',');
            }
            writer.append(')');
        }

        public String toDescriptor() {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            for (String parameterType : this.parameters) {
                sb.append(DescriptorUtils.javaTypeToDescriptor(parameterType));
            }
            sb.append(')');
            sb.append(DescriptorUtils.javaTypeToDescriptor(this.type));
            return sb.toString();
        }

        @Override
        public boolean isMethodSignature() {
            return true;
        }

        @Override
        public MethodSignature asMethodSignature() {
            return this;
        }
    }

    public static class FieldSignature
    extends Signature {
        public final String type;

        public FieldSignature(String name, String type) {
            super(name);
            this.type = type;
        }

        public static FieldSignature fromDexField(DexField field) {
            return FieldSignature.fromDexField(field, false);
        }

        public static FieldSignature fromDexField(DexField field, boolean withQualifiedName) {
            return new FieldSignature(withQualifiedName ? field.qualifiedName() : field.name.toSourceString(), field.type.toSourceString());
        }

        public DexField toDexField(DexItemFactory factory, DexType clazz) {
            return factory.createField(clazz, factory.createType(DescriptorUtils.javaTypeToDescriptor(this.type)), factory.createString(this.name));
        }

        @Override
        Signature asRenamed(String renamedName) {
            return new FieldSignature(renamedName, this.type);
        }

        @Override
        public Signature.SignatureKind kind() {
            return Signature.SignatureKind.FIELD;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldSignature)) {
                return false;
            }
            FieldSignature that = (FieldSignature)o;
            return this.name.equals(that.name) && this.type.equals(that.type);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode() * 31 + this.type.hashCode();
        }

        @Override
        public String toString() {
            return this.type + " " + this.name;
        }

        @Override
        void write(Writer writer) throws IOException {
            writer.append(this.type);
            writer.append(' ');
            writer.append(this.name);
        }

        @Override
        public boolean isFieldSignature() {
            return true;
        }

        @Override
        public FieldSignature asFieldSignature() {
            return this;
        }
    }

    public static abstract class Signature {
        public final String name;

        protected Signature(String name) {
            this.name = name;
        }

        abstract Signature asRenamed(String var1);

        public abstract SignatureKind kind();

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        abstract void write(Writer var1) throws IOException;

        public boolean isQualified() {
            return this.name.indexOf(46) != -1;
        }

        public String toUnqualifiedName() {
            assert (this.isQualified());
            return this.name.substring(this.name.lastIndexOf(46) + 1);
        }

        public String toHolderFromQualified() {
            assert (this.isQualified());
            return this.name.substring(0, this.name.lastIndexOf(46));
        }

        public boolean isMethodSignature() {
            return false;
        }

        public boolean isFieldSignature() {
            return false;
        }

        public MethodSignature asMethodSignature() {
            return null;
        }

        public FieldSignature asFieldSignature() {
            return null;
        }

        public String toString() {
            try {
                StringWriter writer = new StringWriter();
                this.write(writer);
                return writer.toString();
            }
            catch (IOException e) {
                throw new Unreachable(e);
            }
        }

        static enum SignatureKind {
            METHOD,
            FIELD;

        }
    }
}

