/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.retrace;

import shadow.bundletool.com.android.tools.r8.references.MethodReference;
import shadow.bundletool.com.android.tools.r8.references.TypeReference;

public class RetraceUtils {
    public static String methodDescriptionFromMethodReference(MethodReference methodReference, boolean verbose) {
        if (!verbose || methodReference.isUnknown()) {
            return methodReference.getHolderClass().getTypeName() + "." + methodReference.getMethodName();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(methodReference.getReturnType() == null ? "void" : methodReference.getReturnType().getTypeName());
        sb.append(" ");
        sb.append(methodReference.getHolderClass().getTypeName());
        sb.append(".");
        sb.append(methodReference.getMethodName());
        sb.append("(");
        boolean seenFirstIndex = false;
        for (TypeReference formalType : methodReference.getFormalTypes()) {
            if (seenFirstIndex) {
                sb.append(",");
            }
            seenFirstIndex = true;
            sb.append(formalType.getTypeName());
        }
        sb.append(")");
        return sb.toString();
    }
}

