/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Iterables;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.position.Position;
import shadow.bundletool.com.android.tools.r8.shaking.ClassInlineRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardAccessFlags;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardClassNameList;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardClassSpecification;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardClassType;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardKeepRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardMemberRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardTypeMatcher;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardWildcard;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public abstract class ProguardConfigurationRule
extends ProguardClassSpecification {
    private boolean used = false;

    ProguardConfigurationRule(Origin origin, Position position, String source, ProguardTypeMatcher classAnnotation, ProguardAccessFlags classAccessFlags, ProguardAccessFlags negatedClassAccessFlags, boolean classTypeNegated, ProguardClassType classType, ProguardClassNameList classNames, ProguardTypeMatcher inheritanceAnnotation, ProguardTypeMatcher inheritanceClassName, boolean inheritanceIsExtends, List<ProguardMemberRule> memberRules) {
        super(origin, position, source, classAnnotation, classAccessFlags, negatedClassAccessFlags, classTypeNegated, classType, classNames, inheritanceAnnotation, inheritanceClassName, inheritanceIsExtends, memberRules);
    }

    public boolean isUsed() {
        return this.used;
    }

    public void markAsUsed() {
        this.used = true;
    }

    public boolean isProguardKeepRule() {
        return false;
    }

    public ProguardKeepRule asProguardKeepRule() {
        return null;
    }

    public boolean isClassInlineRule() {
        return false;
    }

    public ClassInlineRule asClassInlineRule() {
        return null;
    }

    Iterable<DexProgramClass> relevantCandidatesForRule(AppView<? extends AppInfoWithSubtyping> appView, Iterable<DexProgramClass> defaultValue) {
        if (this.hasInheritanceClassName() && this.getInheritanceClassName().hasSpecificType()) {
            DexType type = this.getInheritanceClassName().getSpecificType();
            if (appView.verticallyMergedClasses() != null && appView.verticallyMergedClasses().hasBeenMergedIntoSubtype(type)) {
                DexType target = appView.verticallyMergedClasses().getTargetFor(type);
                DexClass clazz = appView.definitionFor(target);
                assert (clazz != null && clazz.isProgramClass());
                return Iterables.concat(ImmutableList.of(clazz.asProgramClass()), DexProgramClass.asProgramClasses(appView.appInfo().subtypes(type), appView));
            }
            return DexProgramClass.asProgramClasses(appView.appInfo().subtypes(type), appView);
        }
        return defaultValue;
    }

    abstract String typeString();

    String modifierString() {
        return null;
    }

    public boolean applyToNonProgramClasses() {
        return false;
    }

    protected Iterable<ProguardWildcard> getWildcards() {
        List<ProguardMemberRule> memberRules = this.getMemberRules();
        Iterable[] iterableArray = new Iterable[5];
        iterableArray[0] = ProguardTypeMatcher.getWildcardsOrEmpty(this.getClassAnnotation());
        iterableArray[1] = ProguardClassNameList.getWildcardsOrEmpty(this.getClassNames());
        iterableArray[2] = ProguardTypeMatcher.getWildcardsOrEmpty(this.getInheritanceAnnotation());
        iterableArray[3] = ProguardTypeMatcher.getWildcardsOrEmpty(this.getInheritanceClassName());
        iterableArray[4] = memberRules != null ? memberRules.stream().map(ProguardMemberRule::getWildcards).flatMap(it -> StreamSupport.stream(it.spliterator(), false))::iterator : Collections::emptyIterator;
        return Iterables.concat(iterableArray);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ProguardConfigurationRule)) {
            return false;
        }
        ProguardConfigurationRule that = (ProguardConfigurationRule)o;
        if (this.used != that.used) {
            return false;
        }
        if (!Objects.equals(this.typeString(), that.typeString())) {
            return false;
        }
        if (!Objects.equals(this.modifierString(), that.modifierString())) {
            return false;
        }
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        int result = 3 * this.typeString().hashCode();
        result = 3 * result + (this.used ? 1 : 0);
        String modifier = this.modifierString();
        result = 3 * result + (modifier != null ? modifier.hashCode() : 0);
        return result + super.hashCode();
    }

    @Override
    protected StringBuilder append(StringBuilder builder, boolean includeMemberRules) {
        builder.append("-");
        builder.append(this.typeString());
        StringUtils.appendNonEmpty(builder, ",", this.modifierString(), null);
        builder.append(' ');
        super.append(builder, includeMemberRules);
        return builder;
    }
}

