/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.utils.DexVersion;

public enum AndroidApiLevel {
    R(30),
    Q(29),
    P(28),
    O_MR1(27),
    O(26),
    N_MR1(25),
    N(24),
    M(23),
    L_MR1(22),
    L(21),
    K_WATCH(20),
    K(19),
    J_MR2(18),
    J_MR1(17),
    J(16),
    I_MR1(15),
    I(14),
    H_MR2(13),
    H_MR1(12),
    H(11),
    G_MR1(10),
    G(9),
    F(8),
    E_MR1(7),
    E_0_1(6),
    E(5),
    D(4),
    C(3),
    B_1_1(2),
    B(1);

    public static final AndroidApiLevel LATEST;
    private final int level;

    private AndroidApiLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public String getName() {
        return "Android " + this.name();
    }

    public static AndroidApiLevel getDefault() {
        return B;
    }

    public DexVersion getDexVersion() {
        return DexVersion.getDexVersion(this);
    }

    public static List<AndroidApiLevel> getAndroidApiLevelsSorted() {
        List<AndroidApiLevel> androidApiLevels = Arrays.asList(AndroidApiLevel.values());
        androidApiLevels.sort(Comparator.comparingInt(AndroidApiLevel::getLevel));
        return androidApiLevels;
    }

    public static AndroidApiLevel getMinAndroidApiLevel(DexVersion dexVersion) {
        switch (dexVersion) {
            case V35: {
                return B;
            }
            case V37: {
                return N;
            }
            case V38: {
                return O;
            }
            case V39: {
                return P;
            }
        }
        throw new Unreachable();
    }

    public static AndroidApiLevel getAndroidApiLevel(int apiLevel) {
        switch (apiLevel) {
            case 0: {
                throw new Unreachable();
            }
            case 1: {
                return B;
            }
            case 2: {
                return B_1_1;
            }
            case 3: {
                return C;
            }
            case 4: {
                return D;
            }
            case 5: {
                return E;
            }
            case 6: {
                return E_0_1;
            }
            case 7: {
                return E_MR1;
            }
            case 8: {
                return F;
            }
            case 9: {
                return G;
            }
            case 10: {
                return G_MR1;
            }
            case 11: {
                return H;
            }
            case 12: {
                return H_MR1;
            }
            case 13: {
                return H_MR2;
            }
            case 14: {
                return I;
            }
            case 15: {
                return I_MR1;
            }
            case 16: {
                return J;
            }
            case 17: {
                return J_MR1;
            }
            case 18: {
                return J_MR2;
            }
            case 19: {
                return K;
            }
            case 20: {
                return K_WATCH;
            }
            case 21: {
                return L;
            }
            case 22: {
                return L_MR1;
            }
            case 23: {
                return M;
            }
            case 24: {
                return N;
            }
            case 25: {
                return N_MR1;
            }
            case 26: {
                return O;
            }
            case 27: {
                return O_MR1;
            }
            case 28: {
                return P;
            }
            case 29: {
                return Q;
            }
        }
        return LATEST;
    }

    public boolean isLessThan(AndroidApiLevel other) {
        return this.level < other.getLevel();
    }

    public boolean isLessThanOrEqualTo(AndroidApiLevel other) {
        return this.level <= other.getLevel();
    }

    public boolean isGreaterThan(AndroidApiLevel other) {
        return other.isLessThan(this);
    }

    public boolean isGreaterThanOrEqualTo(AndroidApiLevel other) {
        return other.isLessThanOrEqualTo(this);
    }

    static {
        LATEST = Q;
    }
}

