/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.position.Position;
import shadow.bundletool.com.android.tools.r8.utils.DiagnosticWithThrowable;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

@Keep
public class ExceptionDiagnostic
extends DiagnosticWithThrowable {
    private final Origin origin;

    public ExceptionDiagnostic(Throwable e, Origin origin) {
        super(e);
        this.origin = origin;
    }

    public ExceptionDiagnostic(ResourceException e) {
        this(e, e.getOrigin());
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Position getPosition() {
        return Position.UNKNOWN;
    }

    @Override
    public String getDiagnosticMessage() {
        Throwable e = this.getThrowable();
        if (e instanceof NoSuchFileException || e instanceof FileNotFoundException) {
            return "File not found: " + e.getMessage();
        }
        if (e instanceof FileAlreadyExistsException) {
            return "File already exists: " + e.getMessage();
        }
        StringWriter stack = new StringWriter();
        e.printStackTrace(new PrintWriter(stack));
        String message = e.getMessage();
        return message != null ? StringUtils.joinLines(message, "Stack trace:", stack.toString()) : StringUtils.joinLines(stack.toString());
    }
}

