/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.DeviceSpecUtils;
import com.android.tools.build.bundletool.model.ConfigurationSizes;
import com.android.tools.build.bundletool.model.GetSizeRequest;
import com.android.tools.build.bundletool.model.SizeConfiguration;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;

public abstract class AbstractSizeAggregator {
    private static final Joiner COMMA_JOINER = Joiner.on((char)',');
    protected final ImmutableMap<String, Long> sizeByApkPaths;
    protected final GetSizeRequest getSizeRequest;

    protected AbstractSizeAggregator(ImmutableMap<String, Long> sizeByApkPaths, GetSizeRequest getSizeRequest) {
        this.sizeByApkPaths = sizeByApkPaths;
        this.getSizeRequest = getSizeRequest;
    }

    public abstract ConfigurationSizes getSize();

    protected abstract ImmutableList<ZipPath> getMatchingApks(Targeting.SdkVersionTargeting var1, Targeting.AbiTargeting var2, Targeting.ScreenDensityTargeting var3, Targeting.LanguageTargeting var4);

    protected ImmutableSet<Targeting.SdkVersionTargeting> getAllSdkVersionTargetings(ImmutableList<Commands.ApkDescription> apkDescriptions) {
        ImmutableSet.Builder sdkVersionTargetingOptions = ImmutableSet.builder();
        if (DeviceSpecUtils.isSdkVersionMissing(this.getSizeRequest.getDeviceSpec())) {
            sdkVersionTargetingOptions.addAll((Iterable)apkDescriptions.stream().map(Commands.ApkDescription::getTargeting).filter(Targeting.ApkTargeting::hasSdkVersionTargeting).map(Targeting.ApkTargeting::getSdkVersionTargeting).collect(ImmutableSet.toImmutableSet()));
        }
        return sdkVersionTargetingOptions.build().isEmpty() ? ImmutableSet.of((Object)Targeting.SdkVersionTargeting.getDefaultInstance()) : sdkVersionTargetingOptions.build();
    }

    protected ImmutableSet<Targeting.AbiTargeting> getAllAbiTargetings(ImmutableList<Commands.ApkDescription> apkDescriptions) {
        ImmutableSet.Builder abiTargetingOptions = ImmutableSet.builder();
        if (DeviceSpecUtils.isAbiMissing(this.getSizeRequest.getDeviceSpec())) {
            abiTargetingOptions.addAll((Iterable)apkDescriptions.stream().map(Commands.ApkDescription::getTargeting).filter(Targeting.ApkTargeting::hasAbiTargeting).map(Targeting.ApkTargeting::getAbiTargeting).collect(ImmutableSet.toImmutableSet()));
        }
        return abiTargetingOptions.build().isEmpty() ? ImmutableSet.of((Object)Targeting.AbiTargeting.getDefaultInstance()) : abiTargetingOptions.build();
    }

    protected ImmutableSet<Targeting.ScreenDensityTargeting> getAllScreenDensityTargetings(ImmutableList<Commands.ApkDescription> apkDescriptions) {
        ImmutableSet.Builder screenDensityTargetingOptions = ImmutableSet.builder();
        if (DeviceSpecUtils.isScreenDensityMissing(this.getSizeRequest.getDeviceSpec())) {
            screenDensityTargetingOptions.addAll((Iterable)apkDescriptions.stream().map(Commands.ApkDescription::getTargeting).filter(Targeting.ApkTargeting::hasScreenDensityTargeting).map(Targeting.ApkTargeting::getScreenDensityTargeting).collect(ImmutableSet.toImmutableSet()));
        }
        return screenDensityTargetingOptions.build().isEmpty() ? ImmutableSet.of((Object)Targeting.ScreenDensityTargeting.getDefaultInstance()) : screenDensityTargetingOptions.build();
    }

    protected ImmutableSet<Targeting.LanguageTargeting> getAllLanguageTargetings(ImmutableList<Commands.ApkDescription> apkDescriptions) {
        ImmutableSet.Builder languageTargetingOptions = ImmutableSet.builder();
        if (DeviceSpecUtils.isLocalesMissing(this.getSizeRequest.getDeviceSpec())) {
            languageTargetingOptions.addAll((Iterable)apkDescriptions.stream().map(Commands.ApkDescription::getTargeting).filter(Targeting.ApkTargeting::hasLanguageTargeting).map(Targeting.ApkTargeting::getLanguageTargeting).collect(ImmutableSet.toImmutableSet()));
        }
        return languageTargetingOptions.build().isEmpty() ? ImmutableSet.of((Object)Targeting.LanguageTargeting.getDefaultInstance()) : languageTargetingOptions.build();
    }

    protected ConfigurationSizes getSizesPerConfiguration(ImmutableSet<Targeting.SdkVersionTargeting> sdkTargetingOptions, ImmutableSet<Targeting.AbiTargeting> abiTargetingOptions, ImmutableSet<Targeting.LanguageTargeting> languageTargetingOptions, ImmutableSet<Targeting.ScreenDensityTargeting> screenDensityTargetingOptions) {
        HashMap<SizeConfiguration, Long> minSizeByConfiguration = new HashMap<SizeConfiguration, Long>();
        HashMap<SizeConfiguration, Long> maxSizeByConfiguration = new HashMap<SizeConfiguration, Long>();
        for (Targeting.SdkVersionTargeting sdkVersionTargeting : sdkTargetingOptions) {
            for (Targeting.AbiTargeting abiTargeting : abiTargetingOptions) {
                for (Targeting.ScreenDensityTargeting screenDensityTargeting : screenDensityTargetingOptions) {
                    for (Targeting.LanguageTargeting languageTargeting : languageTargetingOptions) {
                        SizeConfiguration configuration = this.mergeWithDeviceSpec(this.getSizeConfiguration(sdkVersionTargeting, abiTargeting, screenDensityTargeting, languageTargeting), this.getSizeRequest.getDeviceSpec());
                        long compressedSize = this.getCompressedSize(this.getMatchingApks(sdkVersionTargeting, abiTargeting, screenDensityTargeting, languageTargeting));
                        minSizeByConfiguration.merge(configuration, compressedSize, Math::min);
                        maxSizeByConfiguration.merge(configuration, compressedSize, Math::max);
                    }
                }
            }
        }
        return ConfigurationSizes.create((ImmutableMap<SizeConfiguration, Long>)ImmutableMap.copyOf(minSizeByConfiguration), (ImmutableMap<SizeConfiguration, Long>)ImmutableMap.copyOf(maxSizeByConfiguration));
    }

    protected SizeConfiguration getSizeConfiguration(Targeting.SdkVersionTargeting sdkVersionTargeting, Targeting.AbiTargeting abiTargeting, Targeting.ScreenDensityTargeting screenDensityTargeting, Targeting.LanguageTargeting languageTargeting) {
        ImmutableSet<GetSizeRequest.Dimension> dimensions = this.getSizeRequest.getDimensions();
        SizeConfiguration.Builder sizeConfiguration = SizeConfiguration.builder();
        if (dimensions.contains((Object)GetSizeRequest.Dimension.SDK)) {
            SizeConfiguration.getSdkName(sdkVersionTargeting).ifPresent(sizeConfiguration::setSdkVersion);
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.ABI)) {
            SizeConfiguration.getAbiName(abiTargeting).ifPresent(sizeConfiguration::setAbi);
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.SCREEN_DENSITY)) {
            SizeConfiguration.getScreenDensityName(screenDensityTargeting).ifPresent(sizeConfiguration::setScreenDensity);
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.LANGUAGE)) {
            SizeConfiguration.getLocaleName(languageTargeting).ifPresent(sizeConfiguration::setLocale);
        }
        return sizeConfiguration.build();
    }

    protected Devices.DeviceSpec getDeviceSpec(Devices.DeviceSpec deviceSpec, Targeting.SdkVersionTargeting sdkVersionTargeting, Targeting.AbiTargeting abiTargeting, Targeting.ScreenDensityTargeting screenDensityTargeting, Targeting.LanguageTargeting languageTargeting) {
        return new DeviceSpecUtils.DeviceSpecFromTargetingBuilder(deviceSpec).setSdkVersion(sdkVersionTargeting).setSupportedAbis(abiTargeting).setScreenDensity(screenDensityTargeting).setSupportedLocales(languageTargeting).build();
    }

    protected SizeConfiguration mergeWithDeviceSpec(SizeConfiguration getSizeConfiguration, Devices.DeviceSpec deviceSpec) {
        ImmutableSet<GetSizeRequest.Dimension> dimensions = this.getSizeRequest.getDimensions();
        SizeConfiguration.Builder mergedSizeConfiguration = getSizeConfiguration.toBuilder();
        if (dimensions.contains((Object)GetSizeRequest.Dimension.ABI) && !DeviceSpecUtils.isAbiMissing(deviceSpec)) {
            mergedSizeConfiguration.setAbi(COMMA_JOINER.join((Iterable)deviceSpec.getSupportedAbisList()));
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.SCREEN_DENSITY) && !DeviceSpecUtils.isScreenDensityMissing(deviceSpec)) {
            mergedSizeConfiguration.setScreenDensity(Integer.toString(deviceSpec.getScreenDensity()));
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.LANGUAGE) && !DeviceSpecUtils.isLocalesMissing(deviceSpec)) {
            mergedSizeConfiguration.setLocale(COMMA_JOINER.join((Iterable)deviceSpec.getSupportedLocalesList()));
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.SDK) && !DeviceSpecUtils.isSdkVersionMissing(deviceSpec)) {
            mergedSizeConfiguration.setSdkVersion(String.format("%d", deviceSpec.getSdkVersion()));
        }
        return mergedSizeConfiguration.build();
    }

    private long getCompressedSize(ImmutableList<ZipPath> apkPaths) {
        return apkPaths.stream().mapToLong(apkPath -> (Long)this.sizeByApkPaths.get((Object)apkPath.toString())).sum();
    }
}

