/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.tools.build.bundletool.device.AdbCommandOutputValidator;
import com.android.tools.build.bundletool.device.AdbShellCommandTask;
import com.android.tools.build.bundletool.device.AutoValue_MultiPackagesInstaller_InstallableApk;
import com.android.tools.build.bundletool.device.Device;
import com.android.tools.build.bundletool.device.SessionIdParser;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.ddmlib.AdbCommandRejectedException;
import shadow.bundletool.com.android.ddmlib.InstallException;
import shadow.bundletool.com.android.ddmlib.SyncException;
import shadow.bundletool.com.android.ddmlib.TimeoutException;
import shadow.bundletool.com.android.utils.ImmutableCollectors;

public final class MultiPackagesInstaller {
    private static final Logger logger = Logger.getLogger(MultiPackagesInstaller.class.getName());
    private final SessionIdParser sessionIdParser = new SessionIdParser();
    private final Device device;
    private final boolean enableRollback;
    private final boolean noCommit;

    public MultiPackagesInstaller(Device device, boolean enableRollback, boolean noCommit) {
        this.device = device;
        this.enableRollback = enableRollback;
        this.noCommit = noCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(ImmutableListMultimap<String, InstallableApk> apksByPackageName) {
        int parentSessionId = this.startParentSession();
        boolean abandonSession = true;
        try {
            ImmutableList childSessionIds = apksByPackageName.keySet().stream().sorted().map(packageName -> this.installSinglePackage((String)packageName, (ImmutableList<InstallableApk>)apksByPackageName.get(packageName))).collect(ImmutableCollectors.toImmutableList());
            this.attachChildSessionsToParent(parentSessionId, childSessionIds);
            if (this.noCommit) {
                logger.info("Abandoning install session due to 'no commit' requested.");
            }
            abandonSession = this.noCommit;
            this.finalizeParentSession(parentSessionId, abandonSession);
        }
        catch (Throwable throwable) {
            this.finalizeParentSession(parentSessionId, abandonSession);
            logger.info(String.format("Install %s", abandonSession ? "abandoned" : "committed"));
            throw throwable;
        }
        logger.info(String.format("Install %s", abandonSession ? "abandoned" : "committed"));
    }

    private int startParentSession() {
        String startSessionCommand = String.format("pm install-create --multi-package --staged%s", this.enableRollback ? " --enable-rollback" : "");
        return this.sessionIdParser.parse(MultiPackagesInstaller.executeAndValidateSuccess(this.device, startSessionCommand));
    }

    private void finalizeParentSession(int sessionId, boolean abandonSession) {
        String finalizeSessionCommand = String.format("pm %s %d", abandonSession ? "install-abandon" : "install-commit", sessionId);
        MultiPackagesInstaller.executeAndValidateSuccess(this.device, finalizeSessionCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int installSinglePackage(String packageName, ImmutableList<InstallableApk> apks) {
        logger.info(String.format("Installing %s", packageName));
        int childSessionId = this.createChildSession(apks);
        for (int index = 0; index < apks.size(); ++index) {
            InstallableApk apkToInstall = (InstallableApk)apks.get(index);
            logger.info(String.format("\tWriting %s", apkToInstall.getPath().getFileName()));
            Path remotePath = this.syncPackageToDevice(apkToInstall.getPath());
            try {
                this.installRemoteApk(childSessionId, packageName + "_" + index, remotePath);
                continue;
            }
            finally {
                this.removePackageFromDevice(remotePath);
            }
        }
        return childSessionId;
    }

    private Path syncPackageToDevice(Path apk) {
        try {
            return this.device.syncPackageToDevice(apk);
        }
        catch (IOException | AdbCommandRejectedException | SyncException | TimeoutException e4) {
            throw CommandExecutionException.builder().withMessage("Sync APK to device has failed").withCause(e4).build();
        }
    }

    private void removePackageFromDevice(Path remoteApk) {
        try {
            this.device.removeRemotePackage(remoteApk);
        }
        catch (InstallException e4) {
            throw CommandExecutionException.builder().withMessage("Package removal has failed").withCause(e4).build();
        }
    }

    private int createChildSession(ImmutableList<InstallableApk> apks) {
        String childSessionCommand = String.format("pm install-create --staged%s%s", this.enableRollback ? " --enable-rollback" : "", MultiPackagesInstaller.hasApexApk(apks) ? " --apex" : "");
        return this.sessionIdParser.parse(MultiPackagesInstaller.executeAndValidateSuccess(this.device, childSessionCommand));
    }

    private void attachChildSessionsToParent(int parentSessionId, ImmutableList<Integer> childSessionIds) {
        String attachCommand = String.format("pm install-add-session %d %s", parentSessionId, childSessionIds.stream().map(Object::toString).collect(Collectors.joining(" ")));
        MultiPackagesInstaller.executeAndValidateSuccess(this.device, attachCommand);
    }

    private void installRemoteApk(int sessionId, String splitName, Path remoteApk) {
        String installCommand = String.format("pm install-write %d %s %s", sessionId, splitName, remoteApk.toAbsolutePath());
        MultiPackagesInstaller.executeAndValidateSuccess(this.device, installCommand);
    }

    private static boolean hasApexApk(ImmutableList<InstallableApk> apks) {
        return apks.stream().anyMatch(apk -> apk.getPath().getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".apex"));
    }

    private static ImmutableList<String> executeAndValidateSuccess(Device device, String command) {
        ImmutableList<String> output = new AdbShellCommandTask(device, command).execute();
        AdbCommandOutputValidator.validateSuccess(output, command);
        return output;
    }

    @AutoValue
    public static abstract class InstallableApk {
        public static InstallableApk create(Path path, String packageName) {
            return new AutoValue_MultiPackagesInstaller_InstallableApk(path, packageName);
        }

        public abstract Path getPath();

        public abstract String getPackageName();

        InstallableApk() {
        }
    }
}

