/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.utils.files.BufferedIo;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public interface Aapt2Command {
    public void convertApkProtoToBinary(Path var1, Path var2);

    default public ImmutableList<String> dumpBadging(Path apkPath) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static Aapt2Command createFromExecutablePath(final Path aapt2Path) {
        return new Aapt2Command(){

            @Override
            public void convertApkProtoToBinary(Path protoApk, Path binaryApk) {
                new CommandExecutor().execute(aapt2Path.toString(), "convert", "--output-format", "binary", "-o", binaryApk.toString(), protoApk.toString());
            }

            @Override
            public ImmutableList<String> dumpBadging(Path apkPath) {
                return new CommandExecutor().executeAndCapture(aapt2Path.toString(), "dump", "badging", apkPath.toString());
            }
        };
    }

    public static class Aapt2Exception
    extends RuntimeException {
        private Aapt2Exception(String message) {
            super(message);
        }

        private Aapt2Exception(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class CommandExecutor {
        private static final int TIMEOUT_AAPT2_COMMANDS_SECONDS = 300;

        public void execute(String ... command) {
            CommandExecutor.executeImpl(command);
        }

        public ImmutableList<String> executeAndCapture(String ... command) {
            return CommandExecutor.captureOutput(CommandExecutor.executeImpl(command));
        }

        private static Process executeImpl(String ... command) {
            try {
                Process process = new ProcessBuilder(command).redirectErrorStream(true).start();
                if (!process.waitFor(300L, TimeUnit.SECONDS)) {
                    CommandExecutor.printOutput(process);
                    throw new Aapt2Exception("Command timed out: " + Arrays.toString(command));
                }
                if (process.exitValue() != 0) {
                    CommandExecutor.printOutput(process);
                    throw new Aapt2Exception(String.format("Command '%s' didn't terminate successfully (exit code: %d). Check the logs.", Arrays.toString(command), process.exitValue()));
                }
                return process;
            }
            catch (IOException | InterruptedException e4) {
                throw new Aapt2Exception("Error when executing command: " + Arrays.toString(command), e4);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static ImmutableList<String> captureOutput(Process process) {
            try (BufferedReader outputReader = BufferedIo.reader(process.getInputStream());){
                ImmutableList immutableList = ImmutableList.copyOf((Collection)CharStreams.readLines((Readable)outputReader));
                return immutableList;
            }
            catch (IOException e4) {
                throw new UncheckedIOException(e4);
            }
        }

        private static void printOutput(Process process) {
            try (BufferedReader outputReader = BufferedIo.reader(process.getInputStream());){
                String line;
                while ((line = outputReader.readLine()) != null) {
                    System.err.println(line);
                }
            }
            catch (IOException e4) {
                System.err.println("Error when printing output of aapt2 command:" + e4.getMessage());
            }
        }
    }
}

