/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.aapt.ConfigurationOuterClass;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.mergers.SameTargetingMerger;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ManifestEditor;
import com.android.tools.build.bundletool.model.ManifestMutator;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.ResourceTableEntry;
import com.android.tools.build.bundletool.model.SourceStamp;
import com.android.tools.build.bundletool.model.SuffixManager;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.TargetingProtoUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.android.tools.build.bundletool.splitters.AbiNativeLibrariesSplitter;
import com.android.tools.build.bundletool.splitters.AbiPlaceholderInjector;
import com.android.tools.build.bundletool.splitters.ApkGenerationConfiguration;
import com.android.tools.build.bundletool.splitters.DexCompressionSplitter;
import com.android.tools.build.bundletool.splitters.LanguageAssetsSplitter;
import com.android.tools.build.bundletool.splitters.LanguageResourcesSplitter;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.splitters.NativeLibrariesCompressionSplitter;
import com.android.tools.build.bundletool.splitters.SanitizerNativeLibrariesSplitter;
import com.android.tools.build.bundletool.splitters.ScreenDensityResourcesSplitter;
import com.android.tools.build.bundletool.splitters.SplittingPipeline;
import com.android.tools.build.bundletool.splitters.TextureCompressionFormatAssetsSplitter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Int32Value;
import java.util.Optional;
import java.util.function.Predicate;

public class ModuleSplitter {
    private final BundleModule module;
    private final ImmutableSet<String> allModuleNames;
    private final SuffixManager suffixManager = new SuffixManager();
    private final Version bundleVersion;
    private final ApkGenerationConfiguration apkGenerationConfiguration;
    private final Targeting.VariantTargeting variantTargeting;
    private final Optional<String> stampSource;
    private final SourceStamp.StampType stampType;
    private final AbiPlaceholderInjector abiPlaceholderInjector;

    @VisibleForTesting
    public static ModuleSplitter createForTest(BundleModule module, Version bundleVersion) {
        return new ModuleSplitter(module, bundleVersion, ApkGenerationConfiguration.getDefaultInstance(), TargetingProtoUtils.lPlusVariantTargeting(), (ImmutableSet<String>)ImmutableSet.of(), Optional.empty(), null);
    }

    public static ModuleSplitter createNoStamp(BundleModule module, Version bundleVersion, ApkGenerationConfiguration apkGenerationConfiguration, Targeting.VariantTargeting variantTargeting, ImmutableSet<String> allModuleNames) {
        return new ModuleSplitter(module, bundleVersion, apkGenerationConfiguration, variantTargeting, allModuleNames, Optional.empty(), null);
    }

    public static ModuleSplitter create(BundleModule module, Version bundleVersion, ApkGenerationConfiguration apkGenerationConfiguration, Targeting.VariantTargeting variantTargeting, ImmutableSet<String> allModuleNames, Optional<String> stampSource, SourceStamp.StampType stampType) {
        return new ModuleSplitter(module, bundleVersion, apkGenerationConfiguration, variantTargeting, allModuleNames, stampSource, stampType);
    }

    private ModuleSplitter(BundleModule module, Version bundleVersion, ApkGenerationConfiguration apkGenerationConfiguration, Targeting.VariantTargeting variantTargeting, ImmutableSet<String> allModuleNames, Optional<String> stampSource, SourceStamp.StampType stampType) {
        this.module = (BundleModule)Preconditions.checkNotNull((Object)module);
        this.bundleVersion = (Version)Preconditions.checkNotNull((Object)bundleVersion);
        this.apkGenerationConfiguration = (ApkGenerationConfiguration)Preconditions.checkNotNull((Object)apkGenerationConfiguration);
        this.variantTargeting = (Targeting.VariantTargeting)Preconditions.checkNotNull((Object)variantTargeting);
        this.abiPlaceholderInjector = new AbiPlaceholderInjector(apkGenerationConfiguration.getAbisForPlaceholderLibs());
        this.allModuleNames = allModuleNames;
        this.stampSource = stampSource;
        this.stampType = stampType;
    }

    public ImmutableList<ModuleSplit> splitModule() {
        if (this.apkGenerationConfiguration.isForInstantAppVariants()) {
            return (ImmutableList)this.splitModuleInternal().stream().map(this::makeInstantManifestChanges).map(moduleSplit -> moduleSplit.toBuilder().setSplitType(ModuleSplit.SplitType.INSTANT).build()).collect(ImmutableList.toImmutableList());
        }
        return (ImmutableList)this.splitModuleInternal().stream().map(this::removeSplitName).map(this::addPlaceHolderNativeLibsToBaseModule).collect(ImmutableList.toImmutableList());
    }

    private ModuleSplit addPlaceHolderNativeLibsToBaseModule(ModuleSplit moduleSplit) {
        if (!this.apkGenerationConfiguration.getAbisForPlaceholderLibs().isEmpty() && moduleSplit.isBaseModuleSplit() && moduleSplit.isMasterSplit()) {
            return this.abiPlaceholderInjector.addPlaceholderNativeEntries(moduleSplit);
        }
        return moduleSplit;
    }

    private ImmutableList<ModuleSplit> splitModuleInternal() {
        ImmutableList moduleSplits = (ImmutableList)this.runSplitters().stream().map(this::addLPlusApkTargeting).map(this::writeSplitIdInManifest).map(ModuleSplit::addApplicationElementIfMissingInManifest).collect(ImmutableList.toImmutableList());
        if (this.stampSource.isPresent()) {
            return (ImmutableList)moduleSplits.stream().map(moduleSplit -> moduleSplit.writeSourceStampInManifest(this.stampSource.get(), this.stampType)).collect(ImmutableList.toImmutableList());
        }
        return moduleSplits;
    }

    private ImmutableList<ModuleSplit> runSplitters() {
        if (ModuleSplitter.targetsOnlyPreL(this.module)) {
            throw CommandExecutionException.builder().withMessage("Cannot split module '%s' because it does not target devices on Android L or above.", this.module.getName()).build();
        }
        ImmutableList.Builder splits = ImmutableList.builder();
        SplittingPipeline resourcesPipeline = this.createResourcesSplittingPipeline();
        splits.addAll(resourcesPipeline.split(ModuleSplit.forResources(this.module, this.variantTargeting)));
        SplittingPipeline nativePipeline = this.createNativeLibrariesSplittingPipeline();
        splits.addAll(nativePipeline.split(ModuleSplit.forNativeLibraries(this.module, this.variantTargeting)));
        SplittingPipeline assetsPipeline = this.createAssetsSplittingPipeline();
        splits.addAll(assetsPipeline.split(ModuleSplit.forAssets(this.module, this.variantTargeting)));
        SplittingPipeline dexPipeline = this.createDexSplittingPipeline();
        splits.addAll(dexPipeline.split(ModuleSplit.forDex(this.module, this.variantTargeting)));
        splits.add((Object)ModuleSplit.forRoot(this.module, this.variantTargeting));
        ImmutableList<ModuleSplit> mergedSplits = new SameTargetingMerger().merge((ImmutableCollection<ModuleSplit>)ModuleSplitter.applyMasterManifestMutators((ImmutableCollection<ModuleSplit>)splits.build()));
        ImmutableList defaultTargetingSplits = (ImmutableList)mergedSplits.stream().filter(split -> split.getApkTargeting().equals(Targeting.ApkTargeting.getDefaultInstance())).collect(ImmutableList.toImmutableList());
        Preconditions.checkState((defaultTargetingSplits.size() == 1 ? 1 : 0) != 0, (Object)"Expected one split with default targeting.");
        return mergedSplits;
    }

    public ModuleSplit writeSplitIdInManifest(ModuleSplit moduleSplit) {
        String resolvedSuffix = this.suffixManager.createSuffix(moduleSplit);
        return moduleSplit.writeSplitIdInManifest(resolvedSuffix);
    }

    public ModuleSplit removeSplitName(ModuleSplit moduleSplit) {
        return moduleSplit.removeSplitName();
    }

    public ModuleSplit makeInstantManifestChanges(ModuleSplit moduleSplit) {
        AndroidManifest manifest = moduleSplit.getAndroidManifest();
        ManifestEditor editor = manifest.toEditor();
        editor.setTargetSandboxVersion(2);
        if (manifest.getEffectiveMinSdkVersion() < 21) {
            editor.setMinSdkVersion(21);
        }
        editor.removeUnknownSplitComponents(this.allModuleNames);
        return moduleSplit.toBuilder().setAndroidManifest(editor.save()).build();
    }

    private SplittingPipeline createResourcesSplittingPipeline() {
        ImmutableList.Builder resourceSplitters = ImmutableList.builder();
        ImmutableSet<ResourceId> masterPinnedResourceIds = this.apkGenerationConfiguration.getMasterPinnedResourceIds();
        ImmutableSet<String> masterPinnedResourceNames = this.apkGenerationConfiguration.getMasterPinnedResourceNames();
        ImmutableSet<ResourceId> baseManifestReachableResources = this.apkGenerationConfiguration.getBaseManifestReachableResources();
        if (this.apkGenerationConfiguration.getOptimizationDimensions().contains((Object)OptimizationDimension.SCREEN_DENSITY)) {
            resourceSplitters.add((Object)new ScreenDensityResourcesSplitter(this.bundleVersion, arg_0 -> masterPinnedResourceIds.contains(arg_0), arg_0 -> baseManifestReachableResources.contains(arg_0), VersionGuardedFeature.PIN_LOWEST_DENSITY_OF_EACH_STYLE_TO_MASTER.enabledForVersion(this.bundleVersion)));
        }
        if (this.apkGenerationConfiguration.getOptimizationDimensions().contains((Object)OptimizationDimension.LANGUAGE)) {
            com.google.common.base.Predicate pinLangResourceToMaster = Predicates.or((com.google.common.base.Predicate[])new com.google.common.base.Predicate[]{entry -> masterPinnedResourceIds.contains((Object)entry.getResourceId()), entry -> masterPinnedResourceNames.contains((Object)entry.getEntry().getName()), entry -> baseManifestReachableResources.contains((Object)entry.getResourceId()) && !ModuleSplitter.hasDefaultConfig(entry)});
            resourceSplitters.add((Object)new LanguageResourcesSplitter((Predicate<ResourceTableEntry>)pinLangResourceToMaster));
        }
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)resourceSplitters.build());
    }

    public static ImmutableList<ModuleSplit> applyMasterManifestMutators(ImmutableCollection<ModuleSplit> moduleSplits) {
        Preconditions.checkState((moduleSplits.stream().map(ModuleSplit::getVariantTargeting).distinct().count() == 1L ? 1 : 0) != 0, (Object)"Expected same variant targeting across all splits.");
        ImmutableList manifestMutators = (ImmutableList)moduleSplits.stream().flatMap(moduleSplit -> moduleSplit.getMasterManifestMutators().stream()).collect(ImmutableList.toImmutableList());
        return (ImmutableList)moduleSplits.stream().map(moduleSplit -> {
            if (moduleSplit.isMasterSplit()) {
                moduleSplit = moduleSplit.toBuilder().setAndroidManifest(moduleSplit.getAndroidManifest().applyMutators((ImmutableList<ManifestMutator>)manifestMutators)).build();
            }
            return moduleSplit;
        }).collect(ImmutableList.toImmutableList());
    }

    private SplittingPipeline createNativeLibrariesSplittingPipeline() {
        ImmutableList.Builder nativeSplitters = ImmutableList.builder();
        if (this.apkGenerationConfiguration.getEnableNativeLibraryCompressionSplitter()) {
            nativeSplitters.add((Object)new NativeLibrariesCompressionSplitter(this.apkGenerationConfiguration));
        }
        if (this.apkGenerationConfiguration.getOptimizationDimensions().contains((Object)OptimizationDimension.ABI)) {
            nativeSplitters.add((Object)new AbiNativeLibrariesSplitter());
        }
        nativeSplitters.add((Object)new SanitizerNativeLibrariesSplitter());
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)nativeSplitters.build());
    }

    private SplittingPipeline createAssetsSplittingPipeline() {
        ImmutableList.Builder assetsSplitters = ImmutableList.builder();
        if (this.apkGenerationConfiguration.getOptimizationDimensions().contains((Object)OptimizationDimension.LANGUAGE)) {
            assetsSplitters.add((Object)LanguageAssetsSplitter.create());
        }
        if (this.apkGenerationConfiguration.getOptimizationDimensions().contains((Object)OptimizationDimension.TEXTURE_COMPRESSION_FORMAT)) {
            assetsSplitters.add((Object)TextureCompressionFormatAssetsSplitter.create(this.apkGenerationConfiguration.shouldStripTargetingSuffix(OptimizationDimension.TEXTURE_COMPRESSION_FORMAT)));
        }
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)assetsSplitters.build());
    }

    private SplittingPipeline createDexSplittingPipeline() {
        ImmutableList.Builder dexSplitters = ImmutableList.builder();
        if (this.apkGenerationConfiguration.getEnableDexCompressionSplitter()) {
            dexSplitters.add((Object)new DexCompressionSplitter());
        }
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)dexSplitters.build());
    }

    private static boolean targetsOnlyPreL(BundleModule module) {
        Optional<Integer> maxSdkVersion = module.getAndroidManifest().getMaxSdkVersion();
        return maxSdkVersion.isPresent() && maxSdkVersion.get() < 21;
    }

    private ModuleSplit addLPlusApkTargeting(ModuleSplit split) {
        if (split.getApkTargeting().hasSdkVersionTargeting()) {
            Preconditions.checkState((split.getApkTargeting().getSdkVersionTargeting().getValue(0).getMin().getValue() >= 21 ? 1 : 0) != 0, (Object)"Module Split should target SDK versions above L.");
            return split;
        }
        return split.toBuilder().setApkTargeting(split.getApkTargeting().toBuilder().setSdkVersionTargeting(Targeting.SdkVersionTargeting.newBuilder().addValue(Targeting.SdkVersion.newBuilder().setMin(Int32Value.newBuilder().setValue(21)))).build()).build();
    }

    private static boolean hasDefaultConfig(ResourceTableEntry entry) {
        return entry.getEntry().getConfigValueList().stream().anyMatch(configValue -> configValue.getConfig().equals((Object)ConfigurationOuterClass.Configuration.getDefaultInstance()));
    }
}

