/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils;

import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.concurrent.ExecutionException;

public final class ConcurrencyUtils {
    public static <T> ImmutableList<T> waitForAll(Iterable<ListenableFuture<T>> futures) {
        try {
            return ImmutableList.copyOf((Collection)((Collection)Futures.allAsList(futures).get()));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CommandExecutionException("A concurrent operation failed.", e);
        }
    }

    private ConcurrencyUtils() {
    }
}

