/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.android.tools.build.bundletool.version.BundleToolVersion;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class BundleConfigValidator
extends SubValidator {
    private static final ImmutableSet<String> FORBIDDEN_CHARS_IN_GLOB = ImmutableSet.of((Object)"\n", (Object)"\\\\");

    @Override
    public void validateBundle(AppBundle bundle) {
        Config.BundleConfig bundleConfig = bundle.getBundleConfig();
        this.validateVersion(bundleConfig);
        this.validateCompression(bundleConfig.getCompression());
        this.validateOptimizations(bundleConfig.getOptimizations());
    }

    private void validateCompression(Config.Compression compression) {
        FileSystem fileSystem = FileSystems.getDefault();
        for (String pattern : compression.getUncompressedGlobList()) {
            if (FORBIDDEN_CHARS_IN_GLOB.stream().anyMatch(pattern::contains)) {
                throw ValidationException.builder().withMessage("Invalid uncompressed glob: '%s'.", pattern).build();
            }
            try {
                fileSystem.getPathMatcher("glob:" + pattern);
            }
            catch (IllegalArgumentException e) {
                throw ValidationException.builder().withCause(e).withMessage("Invalid uncompressed glob: '%s'.", pattern).build();
            }
        }
    }

    private void validateOptimizations(Config.Optimizations optimizations) {
        ImmutableList duplicateSplitDimensions = (ImmutableList)optimizations.getSplitsConfig().getSplitDimensionList().stream().map(Config.SplitDimension::getValue).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(mapEntry -> (Long)mapEntry.getValue() > 1L).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        if (!duplicateSplitDimensions.isEmpty()) {
            throw ValidationException.builder().withMessage("BundleConfig.pb contains duplicate split dimensions: %s", duplicateSplitDimensions).build();
        }
    }

    private void validateVersion(Config.BundleConfig bundleConfig) {
        try {
            BundleToolVersion.getVersionFromBundleConfig(bundleConfig);
        }
        catch (ValidationException e) {
            throw ValidationException.builder().withCause(e).withMessage("Invalid version in the BundleConfig.pb file.").build();
        }
    }
}

