/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import shadow.bundletool.com.android.tools.r8.BaseCompilerCommand;
import shadow.bundletool.com.android.tools.r8.ClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.DexFilePerClassFileConsumer;
import shadow.bundletool.com.android.tools.r8.DexIndexedConsumer;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.ProgramConsumer;
import shadow.bundletool.com.android.tools.r8.StringConsumer;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApp;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class AndroidAppConsumers {
    private final AndroidApp.Builder builder = AndroidApp.builder();
    private boolean closed = false;
    private ProgramConsumer programConsumer = null;
    private StringConsumer proguardMapConsumer = null;

    public AndroidAppConsumers() {
    }

    public AndroidAppConsumers(BaseCompilerCommand.Builder builder) {
        builder.setProgramConsumer(this.wrapProgramConsumer(builder.getProgramConsumer()));
    }

    public AndroidAppConsumers(InternalOptions options) {
        options.programConsumer = this.wrapProgramConsumer(options.programConsumer);
        options.proguardMapConsumer = this.wrapProguardMapConsumer(options.proguardMapConsumer);
    }

    public ProgramConsumer wrapProgramConsumer(ProgramConsumer consumer) {
        assert (this.programConsumer == null);
        if (consumer instanceof ClassFileConsumer) {
            this.wrapClassFileConsumer((ClassFileConsumer)consumer);
        } else if (consumer instanceof DexIndexedConsumer) {
            this.wrapDexIndexedConsumer((DexIndexedConsumer)consumer);
        } else if (consumer instanceof DexFilePerClassFileConsumer) {
            this.wrapDexFilePerClassFileConsumer((DexFilePerClassFileConsumer)consumer);
        } else {
            assert (consumer == null);
            this.wrapDexIndexedConsumer(null);
        }
        assert (this.programConsumer != null);
        return this.programConsumer;
    }

    public StringConsumer wrapProguardMapConsumer(StringConsumer consumer) {
        assert (this.proguardMapConsumer == null);
        if (consumer != null) {
            this.proguardMapConsumer = new StringConsumer.ForwardingConsumer(consumer){

                @Override
                public void accept(String string, DiagnosticsHandler handler) {
                    super.accept(string, handler);
                    AndroidAppConsumers.this.builder.setProguardMapOutputData(string);
                }
            };
        }
        return this.proguardMapConsumer;
    }

    public DexIndexedConsumer wrapDexIndexedConsumer(DexIndexedConsumer consumer) {
        assert (this.programConsumer == null);
        DexIndexedConsumer.ForwardingConsumer wrapped = new DexIndexedConsumer.ForwardingConsumer(consumer){
            private Int2ReferenceSortedMap<DescriptorsWithContents> files;
            {
                this.files = new Int2ReferenceAVLTreeMap();
            }

            @Override
            public void accept(int fileIndex, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
                super.accept(fileIndex, data, descriptors, handler);
                this.addDexFile(fileIndex, data, descriptors);
            }

            @Override
            public void finished(DiagnosticsHandler handler) {
                super.finished(handler);
                AndroidAppConsumers.this.closed = true;
                this.files.forEach((v, d) -> AndroidAppConsumers.this.builder.addDexProgramData(d.contents, d.descriptors));
                this.files = null;
            }

            synchronized void addDexFile(int fileIndex, byte[] data, Set<String> descriptors) {
                this.files.put(fileIndex, (Object)new DescriptorsWithContents(descriptors, data));
            }
        };
        this.programConsumer = wrapped;
        return wrapped;
    }

    public DexFilePerClassFileConsumer wrapDexFilePerClassFileConsumer(DexFilePerClassFileConsumer consumer) {
        assert (this.programConsumer == null);
        DexFilePerClassFileConsumer.ForwardingConsumer wrapped = new DexFilePerClassFileConsumer.ForwardingConsumer(consumer){
            private TreeMap<String, DescriptorsWithContents> files;
            {
                this.files = new TreeMap();
            }

            @Override
            public void accept(String primaryClassDescriptor, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
                super.accept(primaryClassDescriptor, data, descriptors, handler);
                this.addDexFile(primaryClassDescriptor, data, descriptors);
            }

            synchronized void addDexFile(String primaryClassDescriptor, byte[] data, Set<String> descriptors) {
                this.files.put(primaryClassDescriptor, new DescriptorsWithContents(descriptors, data));
            }

            @Override
            public void finished(DiagnosticsHandler handler) {
                super.finished(handler);
                AndroidAppConsumers.this.closed = true;
                this.files.forEach((v, d) -> AndroidAppConsumers.this.builder.addDexProgramData(d.contents, d.descriptors, (String)v));
                this.files = null;
            }
        };
        this.programConsumer = wrapped;
        return wrapped;
    }

    public ClassFileConsumer wrapClassFileConsumer(ClassFileConsumer consumer) {
        assert (this.programConsumer == null);
        ClassFileConsumer.ForwardingConsumer wrapped = new ClassFileConsumer.ForwardingConsumer(consumer){
            private List<DescriptorsWithContents> files;
            {
                this.files = new ArrayList<DescriptorsWithContents>();
            }

            @Override
            public void accept(byte[] data, String descriptor, DiagnosticsHandler handler) {
                super.accept(data, descriptor, handler);
                this.addClassFile(data, descriptor);
            }

            synchronized void addClassFile(byte[] data, String descriptor) {
                this.files.add(new DescriptorsWithContents(Collections.singleton(descriptor), data));
            }

            @Override
            public void finished(DiagnosticsHandler handler) {
                super.finished(handler);
                AndroidAppConsumers.this.closed = true;
                this.files.forEach(d -> AndroidAppConsumers.this.builder.addClassProgramData(d.contents, Origin.unknown(), d.descriptors));
                this.files = null;
            }
        };
        this.programConsumer = wrapped;
        return wrapped;
    }

    public AndroidApp build() {
        assert (this.closed);
        return this.builder.build();
    }

    private static class DescriptorsWithContents {
        final Set<String> descriptors;
        final byte[] contents;

        private DescriptorsWithContents(Set<String> descriptors, byte[] contents) {
            this.descriptors = descriptors;
            this.contents = contents;
        }
    }
}

