/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.io.ApkSetBuilderFactory;
import com.android.tools.build.bundletool.io.AutoValue_ApkSerializerManager_VariantKey;
import com.android.tools.build.bundletool.model.ApkListener;
import com.android.tools.build.bundletool.model.ApkModifier;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.GeneratedApks;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.targeting.TargetingComparators;
import com.android.tools.build.bundletool.utils.CollectorUtils;
import com.android.tools.build.bundletool.utils.ConcurrencyUtils;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Comparator;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ApkSerializerManager {
    private final ListeningExecutorService executorService;
    private final ApkListener apkListener;
    private final ApkModifier apkModifier;
    private final int firstVariantNumber;
    private final AppBundle appBundle;
    private final ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder;

    public ApkSerializerManager(AppBundle appBundle, ApkSetBuilderFactory.ApkSetBuilder apkSetBuilder, ListeningExecutorService executorService, ApkListener apkListener, ApkModifier apkModifier, int firstVariantNumber) {
        this.appBundle = appBundle;
        this.apkSetBuilder = apkSetBuilder;
        this.executorService = executorService;
        this.apkListener = apkListener;
        this.apkModifier = apkModifier;
        this.firstVariantNumber = firstVariantNumber;
    }

    public ImmutableList<Commands.Variant> serializeUniversalApk(GeneratedApks generatedApks) {
        Preconditions.checkArgument((generatedApks.getSplitApks().isEmpty() && generatedApks.getInstantApks().isEmpty() ? 1 : 0) != 0, (Object)"Internal error: For universal APK expecting only standalone APKs.");
        return this.serializeApks(generatedApks, true, Optional.empty());
    }

    public ImmutableList<Commands.Variant> serializeApksForDevice(GeneratedApks generatedApks, Devices.DeviceSpec deviceSpec) {
        return this.serializeApks(generatedApks, false, Optional.of(deviceSpec));
    }

    public ImmutableList<Commands.Variant> serializeApks(GeneratedApks generatedApks) {
        return this.serializeApks(generatedApks, false, Optional.empty());
    }

    private ImmutableList<Commands.Variant> serializeApks(GeneratedApks generatedApks, boolean isUniversalApk, Optional<Devices.DeviceSpec> deviceSpec) {
        com.google.common.base.Predicate deviceFilter = deviceSpec.isPresent() ? new ApkMatcher(deviceSpec.get())::matchesModuleSplitByTargeting : Predicates.alwaysTrue();
        AtomicInteger variantNumberCounter = new AtomicInteger(this.firstVariantNumber);
        ImmutableMap variantNumberByVariantKey = (ImmutableMap)generatedApks.getAllApksStream().map(VariantKey::create).sorted().distinct().collect(ImmutableMap.toImmutableMap(Function.identity(), unused -> variantNumberCounter.getAndIncrement()));
        ApkSerializer apkSerializer = new ApkSerializer(this.apkListener, isUniversalApk);
        ImmutableListMultimap<VariantKey, ModuleSplit> splitByVariant = generatedApks.getAllApksStream().filter((Predicate<ModuleSplit>)deviceFilter).map(split -> {
            int variantNumber = (Integer)variantNumberByVariantKey.get((Object)VariantKey.create(split));
            return this.modifyApk((ModuleSplit)split, variantNumber);
        }).collect(CollectorUtils.groupingBySortedKeys(VariantKey::create, ApkSerializerManager::clearVariantTargeting));
        ImmutableMap apkDescriptionBySplit = splitByVariant.values().stream().distinct().collect(Collectors.collectingAndThen(ImmutableMap.toImmutableMap(Function.identity(), split -> this.executorService.submit(() -> apkSerializer.serialize((ModuleSplit)split))), ConcurrencyUtils::waitForAll));
        ImmutableList.Builder variants = ImmutableList.builder();
        for (VariantKey variantKey : splitByVariant.keySet()) {
            Commands.Variant.Builder variant = Commands.Variant.newBuilder().setVariantNumber((Integer)variantNumberByVariantKey.get((Object)variantKey)).setTargeting(variantKey.getVariantTargeting());
            Multimap splitsByModuleName = (Multimap)splitByVariant.get((Object)variantKey).stream().collect(CollectorUtils.groupingBySortedKeys(ModuleSplit::getModuleName));
            for (BundleModuleName moduleName : splitsByModuleName.keySet()) {
                variant.addApkSet(Commands.ApkSet.newBuilder().setModuleMetadata(this.appBundle.getModule(moduleName).getModuleMetadata()).addAllApkDescription((Iterable)splitsByModuleName.get((Object)moduleName).stream().map(arg_0 -> ((ImmutableMap)apkDescriptionBySplit).get(arg_0)).collect(ImmutableList.toImmutableList())));
            }
            variants.add((Object)variant.build());
        }
        return variants.build();
    }

    private ModuleSplit modifyApk(ModuleSplit moduleSplit, int variantNumber) {
        ApkModifier.ApkDescription apkDescription = ApkModifier.ApkDescription.builder().setBase(moduleSplit.isBaseModuleSplit()).setApkType(moduleSplit.getSplitType().equals((Object)ModuleSplit.SplitType.STANDALONE) ? ApkModifier.ApkDescription.ApkType.STANDALONE : (moduleSplit.isMasterSplit() ? ApkModifier.ApkDescription.ApkType.MASTER_SPLIT : ApkModifier.ApkDescription.ApkType.CONFIG_SPLIT)).setVariantNumber(variantNumber).setVariantTargeting(moduleSplit.getVariantTargeting()).setApkTargeting(moduleSplit.getApkTargeting()).build();
        return moduleSplit.toBuilder().setAndroidManifest(this.apkModifier.modifyManifest(moduleSplit.getAndroidManifest(), apkDescription)).build();
    }

    private static ModuleSplit clearVariantTargeting(ModuleSplit moduleSplit) {
        return moduleSplit.toBuilder().setVariantTargeting(Targeting.VariantTargeting.getDefaultInstance()).build();
    }

    private final class ApkSerializer {
        private final ApkListener apkListener;
        private final boolean isUniversalApk;

        public ApkSerializer(ApkListener apkListener, boolean isUniversalApk) {
            this.apkListener = apkListener;
            this.isUniversalApk = isUniversalApk;
        }

        public Commands.ApkDescription serialize(ModuleSplit split) {
            Commands.ApkDescription apkDescription;
            switch (split.getSplitType()) {
                case INSTANT: {
                    apkDescription = ApkSerializerManager.this.apkSetBuilder.addInstantApk(split);
                    break;
                }
                case SPLIT: {
                    apkDescription = ApkSerializerManager.this.apkSetBuilder.addSplitApk(split);
                    break;
                }
                case STANDALONE: {
                    apkDescription = this.isUniversalApk ? ApkSerializerManager.this.apkSetBuilder.addStandaloneUniversalApk(split) : ApkSerializerManager.this.apkSetBuilder.addStandaloneApk(split);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected splitType: " + (Object)((Object)split.getSplitType()));
                }
            }
            this.apkListener.onApkFinalized(apkDescription);
            return apkDescription;
        }
    }

    @AutoValue
    static abstract class VariantKey
    implements Comparable<VariantKey> {
        VariantKey() {
        }

        static VariantKey create(ModuleSplit moduleSplit) {
            return new AutoValue_ApkSerializerManager_VariantKey(moduleSplit.getSplitType(), moduleSplit.getVariantTargeting());
        }

        abstract ModuleSplit.SplitType getSplitType();

        abstract Targeting.VariantTargeting getVariantTargeting();

        @Override
        public int compareTo(VariantKey o) {
            return Comparator.comparing(VariantKey::getSplitType, Ordering.explicit((Object)((Object)ModuleSplit.SplitType.INSTANT), (Object[])new ModuleSplit.SplitType[]{ModuleSplit.SplitType.STANDALONE, ModuleSplit.SplitType.SPLIT})).thenComparing(VariantKey::getVariantTargeting, TargetingComparators.VARIANT_TARGETING_COMPARATOR).compare(this, o);
        }
    }
}

