/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.cf.code;

import org.objectweb.asm.MethodVisitor;
import shadow.bundletool.com.android.tools.r8.cf.CfPrinter;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;

public class CfConstNumber
extends CfInstruction {
    private final long value;
    private final ValueType type;

    public CfConstNumber(long value, ValueType type) {
        this.value = value;
        this.type = type;
    }

    public ValueType getType() {
        return this.type;
    }

    public long getRawValue() {
        return this.value;
    }

    public int getIntValue() {
        assert (this.type == ValueType.INT);
        return (int)this.value;
    }

    public long getLongValue() {
        assert (this.type == ValueType.LONG);
        return this.value;
    }

    public float getFloatValue() {
        assert (this.type == ValueType.FLOAT);
        return Float.intBitsToFloat((int)this.value);
    }

    public double getDoubleValue() {
        assert (this.type == ValueType.DOUBLE);
        return Double.longBitsToDouble(this.value);
    }

    @Override
    public void write(MethodVisitor visitor) {
        switch (this.type) {
            case INT: {
                int value = this.getIntValue();
                if (-1 <= value && value <= 5) {
                    visitor.visitInsn(3 + value);
                    break;
                }
                visitor.visitLdcInsn((Object)value);
                break;
            }
            case LONG: {
                long value = this.getLongValue();
                if (value == 0L || value == 1L) {
                    visitor.visitInsn(9 + (int)value);
                    break;
                }
                visitor.visitLdcInsn((Object)value);
                break;
            }
            case FLOAT: {
                float value = this.getFloatValue();
                if (value == 0.0f || value == 1.0f || value == 2.0f) {
                    visitor.visitInsn(11 + (int)value);
                    break;
                }
                visitor.visitLdcInsn((Object)Float.valueOf(value));
                break;
            }
            case DOUBLE: {
                double value = this.getDoubleValue();
                if (value == 0.0 || value == 1.0) {
                    visitor.visitInsn(14 + (int)value);
                    break;
                }
                visitor.visitLdcInsn((Object)value);
                break;
            }
            default: {
                throw new Unreachable("Non supported type in cf backend: " + (Object)((Object)this.type));
            }
        }
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }
}

