/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.code.Format12x;
import shadow.bundletool.com.android.tools.r8.code.NegDouble;
import shadow.bundletool.com.android.tools.r8.code.NegFloat;
import shadow.bundletool.com.android.tools.r8.code.NegInt;
import shadow.bundletool.com.android.tools.r8.code.NegLong;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.ir.analysis.constant.Bottom;
import shadow.bundletool.com.android.tools.r8.ir.analysis.constant.ConstLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.constant.LatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.NumericType;
import shadow.bundletool.com.android.tools.r8.ir.code.Unop;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;

public class Neg
extends Unop {
    public final NumericType type;

    public Neg(NumericType type, Value dest, Value source) {
        super(dest, source);
        this.type = type;
    }

    @Override
    public boolean canBeFolded() {
        return (this.type == NumericType.INT || this.type == NumericType.LONG || this.type == NumericType.FLOAT || this.type == NumericType.DOUBLE) && this.source().isConstant();
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.asNeg().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.ordinal() - other.asNeg().type.ordinal();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        Format12x instruction;
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        int src = builder.allocatedRegister(this.source(), this.getNumber());
        switch (this.type) {
            case INT: {
                instruction = new NegInt(dest, src);
                break;
            }
            case LONG: {
                instruction = new NegLong(dest, src);
                break;
            }
            case FLOAT: {
                instruction = new NegFloat(dest, src);
                break;
            }
            case DOUBLE: {
                instruction = new NegDouble(dest, src);
                break;
            }
            default: {
                throw new Unreachable("Unexpected type " + (Object)((Object)this.type));
            }
        }
        builder.add((Instruction)this, instruction);
    }

    @Override
    public boolean isNeg() {
        return true;
    }

    @Override
    public Neg asNeg() {
        return this;
    }

    @Override
    public LatticeElement evaluate(IRCode code, Function<Value, LatticeElement> getLatticeElement) {
        LatticeElement sourceLattice = getLatticeElement.apply(this.source());
        if (sourceLattice.isConst()) {
            ConstNumber newConst;
            ConstNumber sourceConst = sourceLattice.asConst().getConstNumber();
            ValueType valueType = ValueType.fromNumericType(this.type);
            Value value = code.createValue(valueType, this.getLocalInfo());
            if (this.type == NumericType.INT) {
                newConst = new ConstNumber(value, -sourceConst.getIntValue());
            } else if (this.type == NumericType.LONG) {
                newConst = new ConstNumber(value, -sourceConst.getLongValue());
            } else if (this.type == NumericType.FLOAT) {
                newConst = new ConstNumber(value, Float.floatToIntBits(-sourceConst.getFloatValue()));
            } else {
                assert (this.type == NumericType.DOUBLE);
                newConst = new ConstNumber(value, Double.doubleToLongBits(-sourceConst.getDoubleValue()));
            }
            return new ConstLatticeElement(newConst);
        }
        return Bottom.getInstance();
    }

    @Override
    public int getCfOpcode() {
        switch (this.type) {
            case INT: {
                return 116;
            }
            case FLOAT: {
                return 118;
            }
            case LONG: {
                return 117;
            }
            case DOUBLE: {
                return 119;
            }
        }
        throw new Unreachable("Unexpected type: " + (Object)((Object)this.type));
    }
}

