/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.util.Arrays;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.Code;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugEvent;
import shadow.bundletool.com.android.tools.r8.graph.DexDebugInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;

public class SourceFileRewriter {
    private final AppInfo appInfo;
    private final InternalOptions options;

    public SourceFileRewriter(AppInfo appInfo, InternalOptions options) {
        this.appInfo = appInfo;
        this.options = options;
    }

    public void run() {
        String renameSourceFile = this.options.proguardConfiguration.getRenameSourceFileAttribute();
        if (renameSourceFile == null && this.options.proguardConfiguration.getKeepAttributes().sourceFile) {
            return;
        }
        DexString dexRenameSourceFile = renameSourceFile == null ? this.appInfo.dexItemFactory.createString("") : this.appInfo.dexItemFactory.createString(renameSourceFile);
        for (DexClass dexClass : this.appInfo.classes()) {
            dexClass.sourceFile = dexRenameSourceFile;
            dexClass.forEachMethod(encodedMethod -> {
                if (encodedMethod.accessFlags.isAbstract()) {
                    return;
                }
                Code code = encodedMethod.getCode();
                if (code == null) {
                    return;
                }
                assert (code.isDexCode());
                DexDebugInfo dexDebugInfo = code.asDexCode().getDebugInfo();
                if (dexDebugInfo == null) {
                    return;
                }
                dexDebugInfo.events = (DexDebugEvent[])Arrays.stream(dexDebugInfo.events).filter(dexDebugEvent -> !(dexDebugEvent instanceof DexDebugEvent.SetFile)).toArray(DexDebugEvent[]::new);
            });
        }
    }
}

