/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.ClassKind;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.utils.ClassProvider;

public abstract class ClassMap<T extends DexClass> {
    private final ConcurrentHashMap<DexType, Supplier<T>> classes;
    private final AtomicReference<ClassProvider<T>> classProvider = new AtomicReference();

    ClassMap(ConcurrentHashMap<DexType, Supplier<T>> classes, ClassProvider<T> classProvider) {
        assert (classProvider == null || classProvider.getClassKind() == this.getClassKind());
        this.classes = classes == null ? new ConcurrentHashMap() : classes;
        this.classProvider.set(classProvider);
    }

    abstract T resolveClassConflict(T var1, T var2);

    abstract Supplier<T> getTransparentSupplier(T var1);

    abstract ClassKind getClassKind();

    public String toString() {
        return this.classes.size() + " loaded, provider: " + Objects.toString(this.classProvider.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(DexType type) {
        if (this.classProvider.get() == null) {
            Supplier<T> supplier = this.classes.get(type);
            return (T)(supplier == null ? null : (DexClass)supplier.get());
        }
        Supplier supplier = this.classes.get(type);
        if (supplier != null) {
            return (T)((DexClass)supplier.get());
        }
        ClassMap classMap = this;
        synchronized (classMap) {
            supplier = this.classes.computeIfAbsent(type, key -> {
                if (this.classProvider.get() == null) {
                    return null;
                }
                return new ConcurrentClassLoader(this, this.classProvider.get(), type);
            });
        }
        return (T)(supplier == null ? null : (DexClass)supplier.get());
    }

    public List<T> getAllClasses() {
        if (this.classProvider.get() != null) {
            throw new Unreachable("Getting all classes from not fully loaded collection.");
        }
        ArrayList<DexClass> loadedClasses = new ArrayList<DexClass>();
        for (Supplier<T> supplier : this.classes.values()) {
            DexClass clazz = (DexClass)supplier.get();
            assert (clazz != null);
            loadedClasses.add(clazz);
        }
        return loadedClasses;
    }

    public Iterable<DexType> getAllTypes() {
        return this.classes.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceLoad(Predicate<DexType> load) {
        ClassProvider<T> classProvider = this.classProvider.get();
        if (classProvider == null) {
            return;
        }
        Set knownClasses = Sets.newIdentityHashSet();
        knownClasses.addAll(this.classes.keySet());
        knownClasses.addAll(classProvider.collectTypes());
        for (DexType type : knownClasses) {
            if (!load.test(type)) continue;
            this.get(type);
        }
        ClassMap classMap = this;
        synchronized (classMap) {
            if (this.classProvider.get() == null) {
                return;
            }
            Iterator<Map.Entry<DexType, Supplier<T>>> iterator = this.classes.entrySet().iterator();
            while (iterator.hasNext()) {
                DexClass clazz;
                Map.Entry<DexType, Supplier<T>> e = iterator.next();
                if (knownClasses.contains(e.getKey()) && (clazz = (DexClass)e.getValue().get()) != null) {
                    assert (clazz.type == e.getKey());
                    e.setValue(this.getTransparentSupplier(clazz));
                    continue;
                }
                iterator.remove();
            }
            this.classProvider.set(null);
        }
    }

    private static class ConcurrentClassLoader<T extends DexClass>
    implements Supplier<T> {
        private ClassMap<T> classMap;
        private ClassProvider<T> provider;
        private DexType type;
        private T clazz = null;
        private volatile boolean ready = false;

        private ConcurrentClassLoader(ClassMap<T> classMap, ClassProvider<T> provider, DexType type) {
            this.classMap = classMap;
            this.provider = provider;
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (this.ready) {
                return this.clazz;
            }
            ConcurrentClassLoader concurrentClassLoader = this;
            synchronized (concurrentClassLoader) {
                if (!this.ready) {
                    assert (this.classMap != null && this.provider != null && this.type != null);
                    this.provider.collectClass(this.type, createdClass -> {
                        assert (createdClass != null);
                        assert (this.classMap.getClassKind().isOfKind((DexClass)createdClass));
                        assert (!this.ready);
                        if (createdClass.type != this.type) {
                            throw new CompilationError("Class content provided for type descriptor " + this.type.toSourceString() + " actually defines class " + createdClass.type.toSourceString());
                        }
                        if (this.clazz == null) {
                            this.clazz = createdClass;
                        } else {
                            T oldClass = this.clazz;
                            this.clazz = null;
                            this.clazz = this.classMap.resolveClassConflict((DexClass)oldClass, (DexClass)createdClass);
                        }
                    });
                    this.classMap = null;
                    this.provider = null;
                    this.type = null;
                    this.ready = true;
                }
            }
            assert (this.ready);
            assert (this.classMap == null && this.provider == null && this.type == null);
            return this.clazz;
        }
    }
}

