
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Devices;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_ExtractApksCommand extends ExtractApksCommand {

  private final Path apksArchivePath;
  private final Devices.DeviceSpec deviceSpec;
  private final Optional<Path> outputDirectory;
  private final Optional<ImmutableSet<String>> modules;
  private final boolean instant;

  private AutoValue_ExtractApksCommand(
      Path apksArchivePath,
      Devices.DeviceSpec deviceSpec,
      Optional<Path> outputDirectory,
      Optional<ImmutableSet<String>> modules,
      boolean instant) {
    this.apksArchivePath = apksArchivePath;
    this.deviceSpec = deviceSpec;
    this.outputDirectory = outputDirectory;
    this.modules = modules;
    this.instant = instant;
  }

  @Override
  public Path getApksArchivePath() {
    return apksArchivePath;
  }

  @Override
  public Devices.DeviceSpec getDeviceSpec() {
    return deviceSpec;
  }

  @Override
  public Optional<Path> getOutputDirectory() {
    return outputDirectory;
  }

  @Override
  public Optional<ImmutableSet<String>> getModules() {
    return modules;
  }

  @Override
  public boolean getInstant() {
    return instant;
  }

  @Override
  public String toString() {
    return "ExtractApksCommand{"
        + "apksArchivePath=" + apksArchivePath + ", "
        + "deviceSpec=" + deviceSpec + ", "
        + "outputDirectory=" + outputDirectory + ", "
        + "modules=" + modules + ", "
        + "instant=" + instant
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ExtractApksCommand) {
      ExtractApksCommand that = (ExtractApksCommand) o;
      return (this.apksArchivePath.equals(that.getApksArchivePath()))
           && (this.deviceSpec.equals(that.getDeviceSpec()))
           && (this.outputDirectory.equals(that.getOutputDirectory()))
           && (this.modules.equals(that.getModules()))
           && (this.instant == that.getInstant());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.apksArchivePath.hashCode();
    h *= 1000003;
    h ^= this.deviceSpec.hashCode();
    h *= 1000003;
    h ^= this.outputDirectory.hashCode();
    h *= 1000003;
    h ^= this.modules.hashCode();
    h *= 1000003;
    h ^= this.instant ? 1231 : 1237;
    return h;
  }

  static final class Builder extends ExtractApksCommand.Builder {
    private Path apksArchivePath;
    private Devices.DeviceSpec deviceSpec;
    private Optional<Path> outputDirectory = Optional.empty();
    private Optional<ImmutableSet<String>> modules = Optional.empty();
    private Boolean instant;
    Builder() {
    }
    @Override
    public ExtractApksCommand.Builder setApksArchivePath(Path apksArchivePath) {
      if (apksArchivePath == null) {
        throw new NullPointerException("Null apksArchivePath");
      }
      this.apksArchivePath = apksArchivePath;
      return this;
    }
    @Override
    public ExtractApksCommand.Builder setDeviceSpec(Devices.DeviceSpec deviceSpec) {
      if (deviceSpec == null) {
        throw new NullPointerException("Null deviceSpec");
      }
      this.deviceSpec = deviceSpec;
      return this;
    }
    @Override
    public ExtractApksCommand.Builder setOutputDirectory(Path outputDirectory) {
      if (outputDirectory == null) {
        throw new NullPointerException("Null outputDirectory");
      }
      this.outputDirectory = Optional.of(outputDirectory);
      return this;
    }
    @Override
    public ExtractApksCommand.Builder setModules(ImmutableSet<String> modules) {
      if (modules == null) {
        throw new NullPointerException("Null modules");
      }
      this.modules = Optional.of(modules);
      return this;
    }
    @Override
    public ExtractApksCommand.Builder setInstant(boolean instant) {
      this.instant = instant;
      return this;
    }
    @Override
    public ExtractApksCommand build() {
      String missing = "";
      if (this.apksArchivePath == null) {
        missing += " apksArchivePath";
      }
      if (this.deviceSpec == null) {
        missing += " deviceSpec";
      }
      if (this.instant == null) {
        missing += " instant";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ExtractApksCommand(
          this.apksArchivePath,
          this.deviceSpec,
          this.outputDirectory,
          this.modules,
          this.instant);
    }
  }

}
