/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.commands.CommandScoped;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.optimizations.OptimizationsMerger;
import com.google.common.collect.ImmutableMap;
import dagger.Module;
import dagger.Provides;

@Module
public final class BundleConfigModule {
    @CommandScoped
    @Provides
    static Version provideBundletoolVersion(Config.BundleConfig bundleConfig) {
        return Version.of(bundleConfig.getBundletool().getVersion());
    }

    @CommandScoped
    @Provides
    static ImmutableMap<OptimizationDimension, Config.SuffixStripping> provideSuffixStrippingPerOptimizationDimension(Config.BundleConfig bundleConfig) {
        return OptimizationsMerger.getSuffixStrippings(bundleConfig.getOptimizations().getSplitsConfig().getSplitDimensionList());
    }

    private BundleConfigModule() {
    }
}

