/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.MoreFiles;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.WillNotClose;

public final class GZipUtils {
    public static long calculateGzipCompressedSize(Path file) throws IOException {
        return GZipUtils.calculateGzipCompressedSize(MoreFiles.asByteSource((Path)file, (OpenOption[])new OpenOption[0]));
    }

    public static long calculateGzipCompressedSize(File file) throws IOException {
        return GZipUtils.calculateGzipCompressedSize(com.google.common.io.Files.asByteSource((File)file));
    }

    public static long calculateGzipCompressedSize(ByteSource byteSource) throws IOException {
        try (InputStream is = byteSource.openStream();){
            long l4 = GZipUtils.calculateGzipCompressedSize(is);
            return l4;
        }
    }

    public static long calculateGzipCompressedSize(@WillNotClose InputStream stream) throws IOException {
        CountingOutputStream countingOutputStream = new CountingOutputStream(ByteStreams.nullOutputStream());
        try (GZIPOutputStream compressedStream = new GZIPOutputStream((OutputStream)countingOutputStream);){
            ByteStreams.copy((InputStream)stream, (OutputStream)compressedStream);
        }
        return countingOutputStream.getCount();
    }

    public static void compress(Path sourceFile, Path gzippedDestinationFile) throws IOException {
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(Files.newOutputStream(gzippedDestinationFile, new OpenOption[0]));){
            Files.copy(sourceFile, gzipOutputStream);
        }
    }

    public static void uncompress(Path gzippedSourceFile, Path destinationFile) throws IOException {
        try (GZIPInputStream gzipInputStream = new GZIPInputStream(Files.newInputStream(gzippedSourceFile, new OpenOption[0]));){
            Files.copy(gzipInputStream, destinationFile, new CopyOption[0]);
        }
    }

    private GZipUtils() {
    }
}

