/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.BundleValidationUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.function.Predicate;

public class EntryClashValidator
extends SubValidator {
    private static final Predicate<ZipPath> IS_EXPECTED_TO_BE_DIFFERENT = path -> path.startsWith(BundleModule.DEX_DIRECTORY);

    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        BundleModule baseModule;
        boolean isolatedSplits;
        if (!BundleValidationUtils.isAssetOnlyBundle(modules) && (isolatedSplits = (baseModule = BundleValidationUtils.expectBaseModule(modules)).getAndroidManifest().getIsolatedSplits().orElse(false).booleanValue())) {
            return;
        }
        EntryClashValidator.checkEntryClashes(modules);
    }

    @VisibleForTesting
    static void checkEntryClashes(ImmutableList<BundleModule> modules) {
        HashMap<ZipPath, BundleModule> usedPaths = new HashMap<ZipPath, BundleModule>();
        for (BundleModule module : modules) {
            for (ModuleEntry entry : module.getEntries()) {
                BundleModule otherModuleWithPath;
                if (IS_EXPECTED_TO_BE_DIFFERENT.test(entry.getPath()) || (otherModuleWithPath = usedPaths.putIfAbsent(entry.getPath(), module)) == null) continue;
                EntryClashValidator.checkEqualEntries(entry.getPath(), otherModuleWithPath, module);
            }
        }
    }

    private static void checkEqualEntries(ZipPath path, BundleModule module1, BundleModule module2) {
        ModuleEntry entry2;
        ModuleEntry entry1 = module1.getEntry(path).get();
        if (!entry1.equals(entry2 = module2.getEntry(path).get())) {
            throw InvalidBundleException.builder().withUserMessage("Modules '%s' and '%s' contain entry '%s' with different content.", module1.getName(), module2.getName(), path).build();
        }
    }
}

