/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.SdkMetadataOuterClass;
import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.commands.BuildSdkAsarCommand;
import com.android.tools.build.bundletool.io.SdkAsarSerializer;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.SdkAsar;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.transparency.CodeTransparencyCryptoUtils;
import com.android.tools.build.bundletool.xml.XmlProtoToXmlConverter;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import javax.inject.Inject;
import org.w3c.dom.Document;

public class BuildSdkAsarManager {
    private final BuildSdkAsarCommand command;
    private final SdkBundle sdkBundle;

    @Inject
    BuildSdkAsarManager(BuildSdkAsarCommand command, SdkBundle sdkBundle) {
        this.command = command;
        this.sdkBundle = sdkBundle;
    }

    void execute(Path extractedModulesFilePath) throws IOException {
        if (this.command.getOverwriteOutput() && Files.exists(this.command.getOutputFile(), new LinkOption[0])) {
            MoreFiles.deleteRecursively((Path)this.command.getOutputFile(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        SdkAsarSerializer.writeToDisk(this.generateSdkAsar(extractedModulesFilePath), this.command.getOutputFile());
    }

    private SdkAsar generateSdkAsar(Path extractedModulesFilePath) {
        SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig = this.sdkBundle.getSdkModulesConfig();
        AndroidManifest manifest = this.sdkBundle.getModule().getAndroidManifest();
        Document manifestDoc = XmlProtoToXmlConverter.convert(manifest.getManifestRoot());
        SdkMetadataOuterClass.SdkMetadata.Builder metadata = SdkMetadataOuterClass.SdkMetadata.newBuilder().setPackageName(sdkModulesConfig.getSdkPackageName()).setSdkVersion(sdkModulesConfig.getSdkVersion());
        this.command.getApkSigningCertificate().map(BuildSdkAsarManager::getFormattedCertificateDigest).ifPresent(metadata::setCertificateDigest);
        SdkAsar.Builder asar = SdkAsar.builder().setManifest(manifestDoc).setModule(this.sdkBundle.getModule()).setSdkModulesConfig(sdkModulesConfig).setModulesFile(extractedModulesFilePath.toFile()).setSdkMetadata(metadata.build());
        this.sdkBundle.getSdkInterfaceDescriptors().ifPresent(asar::setSdkInterfaceDescriptors);
        return asar.build();
    }

    private static String getFormattedCertificateDigest(X509Certificate certificate) {
        return CodeTransparencyCryptoUtils.getCertificateFingerprint(certificate).replace(' ', ':');
    }
}

