/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.TargetingProtoUtils;
import com.android.tools.build.bundletool.splitters.ApkGenerationConfiguration;
import com.android.tools.build.bundletool.splitters.BundleModuleVariantGenerator;
import java.util.stream.Stream;

public final class SparseEncodingVariantGenerator
implements BundleModuleVariantGenerator {
    private final ApkGenerationConfiguration apkGenerationConfiguration;

    public SparseEncodingVariantGenerator(ApkGenerationConfiguration apkGenerationConfiguration) {
        this.apkGenerationConfiguration = apkGenerationConfiguration;
    }

    @Override
    public Stream<Targeting.VariantTargeting> generate(BundleModule module) {
        if (!this.apkGenerationConfiguration.getEnableSparseEncodingVariant()) {
            return Stream.of(new Targeting.VariantTargeting[0]);
        }
        if (this.targetsPreO(module)) {
            throw CommandExecutionException.builder().withInternalMessage("Cannot generate variants '%s' with sparse encoding, because it does not target devices on Android O or above.", module.getName()).build();
        }
        return Stream.of(TargetingProtoUtils.variantTargeting(TargetingProtoUtils.sdkVersionTargeting(TargetingProtoUtils.sdkVersionFrom(32))));
    }

    private boolean targetsPreO(BundleModule module) {
        int targetingSdkVersion = module.getAndroidManifest().getEffectiveTargetingSdkVersion();
        return targetingSdkVersion < 26;
    }
}

