/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SdkBundleHasOneModuleValidator
extends SubValidator {
    @Override
    public void validateSdkModulesZipFile(ZipFile modulesFile) {
        this.checkSdkHasSingleModule(modulesFile);
    }

    private void checkSdkHasSingleModule(ZipFile modulesFile) {
        ImmutableSet<ZipPath> moduleDirectories = this.getModuleDirectories(modulesFile);
        if (moduleDirectories.size() != 1) {
            throw InvalidBundleException.builder().withUserMessage("SDK bundles need exactly one module, %d detected.", moduleDirectories.size()).build();
        }
    }

    private ImmutableSet<ZipPath> getModuleDirectories(ZipFile modulesFile) {
        return (ImmutableSet)Collections.list(modulesFile.entries()).stream().map(ZipEntry::getName).map(ZipPath::create).filter(entryPath -> entryPath.getNameCount() > 1).map(entryPath -> entryPath.getName(0)).collect(ImmutableSet.toImmutableSet());
    }
}

