/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.shards;

import com.android.bundle.Config;
import com.android.bundle.Devices;
import com.android.tools.build.bundletool.mergers.SameTargetingMerger;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.shards.SuffixStripper;
import com.android.tools.build.bundletool.splitters.AbiApexImagesSplitter;
import com.android.tools.build.bundletool.splitters.AbiNativeLibrariesSplitter;
import com.android.tools.build.bundletool.splitters.LanguageAssetsSplitter;
import com.android.tools.build.bundletool.splitters.LanguageResourcesSplitter;
import com.android.tools.build.bundletool.splitters.ModuleSplitSplitter;
import com.android.tools.build.bundletool.splitters.SanitizerNativeLibrariesSplitter;
import com.android.tools.build.bundletool.splitters.ScreenDensityResourcesSplitter;
import com.android.tools.build.bundletool.splitters.SplittingPipeline;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;

public class ModuleSplitterForShards {
    private static final ImmutableSet<Config.SplitDimension.Value> SUFFIX_STRIPPING_DIMENSIONS = ImmutableSet.of((Object)((Object)Config.SplitDimension.Value.TEXTURE_COMPRESSION_FORMAT), (Object)((Object)Config.SplitDimension.Value.DEVICE_TIER), (Object)((Object)Config.SplitDimension.Value.COUNTRY_SET));
    private final Version bundleVersion;
    private final Config.BundleConfig bundleConfig;
    private final Optional<Devices.DeviceSpec> deviceSpec;

    @Inject
    public ModuleSplitterForShards(Version bundleVersion, Config.BundleConfig bundleConfig, Optional<Devices.DeviceSpec> deviceSpec) {
        this.bundleVersion = bundleVersion;
        this.bundleConfig = bundleConfig;
        this.deviceSpec = deviceSpec;
    }

    public ImmutableList<ModuleSplit> generateSplits(BundleModule module, ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder rawSplits = ImmutableList.builder();
        SplittingPipeline nativePipeline = this.createNativeLibrariesSplittingPipeline(shardingDimensions);
        rawSplits.addAll(nativePipeline.split(ModuleSplit.forNativeLibraries(module)));
        SplittingPipeline resourcesPipeline = this.createResourcesSplittingPipeline(shardingDimensions);
        rawSplits.addAll(resourcesPipeline.split(ModuleSplit.forResources(module)));
        SplittingPipeline apexPipeline = ModuleSplitterForShards.createApexImagesSplittingPipeline();
        rawSplits.addAll(apexPipeline.split(ModuleSplit.forApex(module)));
        SplittingPipeline assetsPipeline = this.createAssetsSplittingPipeline(shardingDimensions);
        rawSplits.addAll(assetsPipeline.split(ModuleSplit.forAssets(module)));
        rawSplits.add((Object)ModuleSplit.forDex(module));
        rawSplits.add((Object)ModuleSplit.forRoot(module));
        ImmutableList unmergedSplits = rawSplits.build();
        ImmutableList<ModuleSplit> unmergedStrippedSplits = this.stripAssetsWithTargeting((ImmutableList<ModuleSplit>)unmergedSplits);
        ImmutableList mergedSplits = new SameTargetingMerger().merge((ImmutableCollection<ModuleSplit>)unmergedStrippedSplits);
        mergedSplits = (ImmutableList)mergedSplits.stream().map(ModuleSplit::removeSplitName).collect(ImmutableList.toImmutableList());
        long masterSplitCount = mergedSplits.stream().filter(ModuleSplit::isMasterSplit).count();
        Preconditions.checkState((masterSplitCount == 1L ? 1 : 0) != 0, (String)"Expected one master split, got %s.", (long)masterSplitCount);
        return mergedSplits;
    }

    private ImmutableList<ModuleSplit> stripAssetsWithTargeting(ImmutableList<ModuleSplit> splits) {
        ImmutableList dimensionsToStrip = (ImmutableList)this.bundleConfig.getOptimizations().getSplitsConfig().getSplitDimensionList().stream().filter(dimension -> SUFFIX_STRIPPING_DIMENSIONS.contains((Object)dimension.getValue())).collect(ImmutableList.toImmutableList());
        if (dimensionsToStrip.isEmpty()) {
            return splits;
        }
        return (ImmutableList)splits.stream().map(split -> ModuleSplitterForShards.stripAssetsWithTargeting(split, (ImmutableList<Config.SplitDimension>)dimensionsToStrip)).collect(ImmutableList.toImmutableList());
    }

    private static ModuleSplit stripAssetsWithTargeting(ModuleSplit split, ImmutableList<Config.SplitDimension> dimensionsToStrip) {
        for (Config.SplitDimension dimension : dimensionsToStrip) {
            Preconditions.checkArgument((boolean)SUFFIX_STRIPPING_DIMENSIONS.contains((Object)dimension.getValue()));
            split = SuffixStripper.createForDimension(dimension.getValue()).applySuffixStripping(split, dimension.getSuffixStripping());
        }
        return split;
    }

    private SplittingPipeline createNativeLibrariesSplittingPipeline(ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder nativeSplitters = ImmutableList.builder();
        if (shardingDimensions.contains((Object)OptimizationDimension.ABI)) {
            nativeSplitters.add((Object)new AbiNativeLibrariesSplitter());
        }
        nativeSplitters.add((Object)new SanitizerNativeLibrariesSplitter());
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)nativeSplitters.build());
    }

    private SplittingPipeline createResourcesSplittingPipeline(ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder resourceSplitters = ImmutableList.builder();
        if (shardingDimensions.contains((Object)OptimizationDimension.SCREEN_DENSITY)) {
            resourceSplitters.add((Object)new ScreenDensityResourcesSplitter(this.bundleVersion, (Predicate<ResourceId>)Predicates.alwaysFalse(), (Predicate<ResourceId>)Predicates.alwaysFalse(), false));
        }
        if (shardingDimensions.contains((Object)OptimizationDimension.LANGUAGE) && this.shouldSplitByLanguage()) {
            resourceSplitters.add((Object)new LanguageResourcesSplitter());
        }
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)resourceSplitters.build());
    }

    private SplittingPipeline createAssetsSplittingPipeline(ImmutableSet<OptimizationDimension> shardingDimensions) {
        ImmutableList.Builder assetsSplitters = ImmutableList.builder();
        if (shardingDimensions.contains((Object)OptimizationDimension.LANGUAGE) && this.shouldSplitByLanguage()) {
            assetsSplitters.add((Object)LanguageAssetsSplitter.create());
        }
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)assetsSplitters.build());
    }

    private boolean shouldSplitByLanguage() {
        return this.deviceSpec.map(spec -> !spec.getSupportedLocalesList().isEmpty()).orElse(false);
    }

    private static SplittingPipeline createApexImagesSplittingPipeline() {
        return new SplittingPipeline((ImmutableList<ModuleSplitSplitter>)ImmutableList.of((Object)new AbiApexImagesSplitter()));
    }
}

