/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.io.SigningConfigurationHelper;
import com.android.tools.build.bundletool.io.TempDirectory;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.WearApkLocator;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CheckReturnValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.List;
import javax.inject.Inject;
import shadow.bundletool.com.android.apksig.ApkSigner;
import shadow.bundletool.com.android.apksig.apk.ApkFormatException;

class ApkSigner {
    private final SigningConfigurationHelper signingConfigHelper;
    private final TempDirectory tempDirectory;

    @Inject
    ApkSigner(SigningConfigurationHelper signingConfigHelper, TempDirectory tempDirectory) {
        this.signingConfigHelper = signingConfigHelper;
        this.tempDirectory = tempDirectory;
    }

    public void signApk(Path apkPath, ModuleSplit split) {
        if (!this.signingConfigHelper.shouldSignGeneratedApks()) {
            return;
        }
        try (TempDirectory tempDirectory = new TempDirectory(this.getClass().getSimpleName());){
            Path signedApkPath = tempDirectory.getPath().resolve("signed.apk");
            ApkSigner.Builder apkSigner = new ApkSigner.Builder((List<ApkSigner.SignerConfig>)this.signingConfigHelper.getSignerConfigsForSplit(split)).setInputApk(apkPath.toFile()).setOutputApk(signedApkPath.toFile()).setV1SigningEnabled(this.signingConfigHelper.shouldSignWithV1(split)).setV2SigningEnabled(true).setV3SigningEnabled(true).setOtherSignersSignaturesPreserved(false).setMinSdkVersion(split.getAndroidManifest().getEffectiveMinSdkVersion());
            this.signingConfigHelper.getSigningCertificateLineageForSplit(split).ifPresent(apkSigner::setSigningCertificateLineage);
            this.signingConfigHelper.getSourceStampSignerConfig().ifPresent(apkSigner::setSourceStampSignerConfig);
            apkSigner.build().sign();
            Files.move(signedApkPath, apkPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException | ApkFormatException e5) {
            throw CommandExecutionException.builder().withCause(e5).withInternalMessage("Unable to sign APK.").build();
        }
    }

    @CheckReturnValue
    public ModuleSplit signEmbeddedApks(ModuleSplit split) {
        ImmutableSet wear1ApkPaths = ImmutableSet.copyOf(WearApkLocator.findEmbeddedWearApkPaths(split));
        ImmutableList.Builder newEntries = ImmutableList.builder();
        for (ModuleEntry entry : split.getEntries()) {
            ZipPath pathInApk = ApkSerializerHelper.toApkEntryPath(entry.getPath());
            if (entry.getShouldSign() || wear1ApkPaths.contains((Object)pathInApk)) {
                newEntries.add((Object)this.signModuleEntry(split, entry));
                continue;
            }
            newEntries.add((Object)entry);
        }
        return split.toBuilder().setEntries((List<ModuleEntry>)newEntries.build()).build();
    }

    private ModuleEntry signModuleEntry(ModuleSplit split, ModuleEntry entry) {
        try {
            Path tempDir = Files.createTempDirectory(this.tempDirectory.getPath(), this.getClass().getSimpleName(), new FileAttribute[0]);
            Path embeddedApk = tempDir.resolve("embedded.apk");
            try (InputStream entryContent = entry.getContent().openStream();){
                Files.copy(entryContent, embeddedApk, new CopyOption[0]);
            }
            this.signApk(embeddedApk, split);
            return entry.toBuilder().setContent(embeddedApk).setShouldSign(false).build();
        }
        catch (IOException e5) {
            throw new UncheckedIOException(e5);
        }
    }
}

