/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.commands.BuildApksModule;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.SignerConfig;
import com.android.tools.build.bundletool.model.SigningConfiguration;
import com.android.tools.build.bundletool.model.targeting.TargetingUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.google.common.collect.ImmutableList;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import shadow.bundletool.com.android.apksig.ApkSigner;
import shadow.bundletool.com.android.apksig.SigningCertificateLineage;

class SigningConfigurationHelper {
    private static final String SIGNER_CONFIG_NAME = "BNDLTOOL";
    private final Optional<SigningConfiguration> signingConfig;
    private final Optional<SigningConfiguration> sourceStampSigningConfig;
    private final Version bundletoolVersion;

    @Inject
    SigningConfigurationHelper(@BuildApksModule.ApkSigningConfig Optional<SigningConfiguration> signingConfig, @BuildApksModule.StampSigningConfig Optional<SigningConfiguration> sourceStampSigningConfig, Version bundletoolVersion) {
        this.signingConfig = signingConfig;
        this.sourceStampSigningConfig = sourceStampSigningConfig;
        this.bundletoolVersion = bundletoolVersion;
    }

    public boolean shouldSignGeneratedApks() {
        return this.signingConfig.isPresent();
    }

    public ImmutableList<ApkSigner.SignerConfig> getSignerConfigsForSplit(ModuleSplit moduleSplit) {
        if (!this.signingConfig.isPresent()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder signerConfigs = ImmutableList.builder();
        Optional<ApkSigner.SignerConfig> oldestSigner = this.signingConfig.flatMap(SigningConfiguration::getOldestSigner).map(SigningConfigurationHelper::convertToApksigSignerConfig);
        ApkSigner.SignerConfig newestSigner = SigningConfigurationHelper.convertToApksigSignerConfig(this.signingConfig.get().getSignerConfig());
        if (this.shouldSignWithV3Rotation(moduleSplit)) {
            signerConfigs.add((Object)newestSigner);
            oldestSigner.ifPresent(arg_0 -> ((ImmutableList.Builder)signerConfigs).add(arg_0));
        } else {
            signerConfigs.add((Object)oldestSigner.orElse(newestSigner));
        }
        return signerConfigs.build();
    }

    public boolean shouldSignWithV1(ModuleSplit moduleSplit) {
        if (!this.signingConfig.isPresent()) {
            return false;
        }
        int minSdkVersion = moduleSplit.getAndroidManifest().getEffectiveMinSdkVersion();
        return minSdkVersion < 24 || !VersionGuardedFeature.NO_V1_SIGNING_WHEN_POSSIBLE.enabledForVersion(this.bundletoolVersion);
    }

    public boolean shouldSignWithV2() {
        return this.signingConfig.isPresent();
    }

    public boolean shouldSignWithV3Rotation(ModuleSplit moduleSplit) {
        if (!this.signingConfig.isPresent()) {
            return false;
        }
        return SigningConfigurationHelper.getMinSdkVersionTargeting(moduleSplit) >= this.signingConfig.get().getEffectiveMinimumV3RotationApiVersion();
    }

    public Optional<SigningCertificateLineage> getSigningCertificateLineageForSplit(ModuleSplit moduleSplit) {
        return this.signingConfig.flatMap(SigningConfiguration::getSigningCertificateLineage).filter(lineage -> this.shouldSignWithV3Rotation(moduleSplit));
    }

    public Optional<ApkSigner.SignerConfig> getSourceStampSignerConfig() {
        return this.sourceStampSigningConfig.map(SigningConfiguration::getSignerConfig).map(SigningConfigurationHelper::convertToApksigSignerConfig);
    }

    private static int getMinSdkVersionTargeting(ModuleSplit moduleSplit) {
        int minManifestSdkVersion = moduleSplit.getAndroidManifest().getEffectiveMinSdkVersion();
        int minApkTargetingSdkVersion = TargetingUtils.getMinSdk(moduleSplit.getApkTargeting().getSdkVersionTargeting());
        return Math.max(minManifestSdkVersion, minApkTargetingSdkVersion);
    }

    private static ApkSigner.SignerConfig convertToApksigSignerConfig(SignerConfig signerConfig) {
        return new ApkSigner.SignerConfig.Builder(SIGNER_CONFIG_NAME, signerConfig.getPrivateKey(), (List<X509Certificate>)signerConfig.getCertificates()).build();
    }
}

