/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.internal;

import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.ManifestEditor;
import com.android.tools.build.bundletool.model.manifestelements.Activity;
import com.android.tools.build.bundletool.model.manifestelements.IntentFilter;
import com.android.tools.build.bundletool.model.manifestelements.Receiver;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoElementBuilder;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.google.common.base.Preconditions;
import java.util.Optional;

public final class HibernatedAndroidManifestUtils {
    public static final String META_DATA_KEY_HIBERNATED = "shadow.bundletool.com.android.vending.hibernated";
    public static final String REACTIVATE_ACTIVITY_NAME = "com.google.android.hibernation.ReactivateActivity";
    public static final String HOLO_LIGHT_NO_ACTION_BAR_THEME = "@android:style/Theme.Holo.Light.NoActionBar";
    public static final String MAIN_ACTION_NAME = "android.intent.action.MAIN";
    public static final String LAUNCHER_CATEGORY_NAME = "android.intent.category.LAUNCHER";
    public static final String UPDATE_BROADCAST_RECEIVER_NAME = "com.google.android.hibernation.UpdateBroadcastReceiver";
    public static final String MY_PACKAGE_REPLACED_ACTION_NAME = "android.intent.action.MY_PACKAGE_REPLACED";

    public static AndroidManifest createHibernatedManifest(AndroidManifest manifest) {
        Preconditions.checkNotNull((Object)manifest);
        ManifestEditor editor = new ManifestEditor(HibernatedAndroidManifestUtils.createMinimalManifestTag(), BundleToolVersion.getCurrentVersion()).setPackage(manifest.getPackageName()).addMetaDataBoolean(META_DATA_KEY_HIBERNATED, true);
        manifest.getVersionCode().ifPresent(editor::setVersionCode);
        manifest.getVersionName().ifPresent(editor::setVersionName);
        manifest.getSharedUserId().ifPresent(editor::setSharedUserId);
        manifest.getSharedUserLabel().ifPresent(editor::setSharedUserLabel);
        manifest.getMinSdkVersion().ifPresent(editor::setMinSdkVersion);
        manifest.getMaxSdkVersion().ifPresent(editor::setMaxSdkVersion);
        manifest.getTargetSdkVersion().ifPresent(editor::setTargetSdkVersion);
        if (manifest.hasApplicationElement()) {
            manifest.getDescription().ifPresent(editor::setDescription);
            manifest.getHasFragileUserData().ifPresent(editor::setHasFragileUserData);
            manifest.getIsGame().ifPresent(editor::setIsGame);
            manifest.getIcon().ifPresent(editor::setIcon);
            if (manifest.hasLabelString()) {
                manifest.getLabelString().ifPresent(editor::setLabelAsString);
            }
            if (manifest.hasLabelRefId()) {
                manifest.getLabelRefId().ifPresent(editor::setLabelAsRefId);
            }
            HibernatedAndroidManifestUtils.getHibernatedAllowBackup(manifest).ifPresent(editor::setAllowBackup);
            manifest.getFullBackupOnly().ifPresent(editor::setFullBackupOnly);
            manifest.getFullBackupContent().ifPresent(editor::setFullBackupContent);
            manifest.getDataExtractionRules().ifPresent(editor::setDataExtractionRules);
        }
        editor.addActivity(HibernatedAndroidManifestUtils.createReactivateActivity());
        editor.addReceiver(HibernatedAndroidManifestUtils.createUpdateBroadcastReceiver());
        return editor.save();
    }

    private static Optional<Boolean> getHibernatedAllowBackup(AndroidManifest manifest) {
        return manifest.getAllowBackup().orElse(true) != false && (!manifest.hasBackupAgent() || manifest.getFullBackupOnly().orElse(false) != false) ? manifest.getAllowBackup() : Optional.of(Boolean.FALSE);
    }

    private static XmlProtoNode createMinimalManifestTag() {
        return XmlProtoNode.createElementNode(XmlProtoElementBuilder.create("manifest").addNamespaceDeclaration("android", "http://schemas.android.com/apk/res/android").build());
    }

    private static Activity createReactivateActivity() {
        return Activity.builder().setName(REACTIVATE_ACTIVITY_NAME).setTheme(HOLO_LIGHT_NO_ACTION_BAR_THEME).setExported(true).setExcludeFromRecents(true).setStateNotNeeded(true).setIntentFilter(IntentFilter.builder().setActionName(MAIN_ACTION_NAME).setCategoryName(LAUNCHER_CATEGORY_NAME).build()).build();
    }

    private static Receiver createUpdateBroadcastReceiver() {
        return Receiver.builder().setName(UPDATE_BROADCAST_RECEIVER_NAME).setExported(true).setIntentFilter(IntentFilter.builder().setActionName(MY_PACKAGE_REPLACED_ACTION_NAME).build()).build();
    }

    private HibernatedAndroidManifestUtils() {
    }
}

