/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.tools.build.bundletool.io.ApkSerializerHelper;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import javax.inject.Inject;

public class StandaloneApkSerializer {
    private final ApkSerializerHelper apkSerializerHelper;

    @Inject
    public StandaloneApkSerializer(ApkSerializerHelper apkSerializerHelper) {
        this.apkSerializerHelper = apkSerializerHelper;
    }

    public Commands.ApkDescription writeToDisk(ModuleSplit standaloneSplit, Path outputDirectory, ZipPath apkPath) {
        return this.writeToDiskInternal(standaloneSplit, outputDirectory, apkPath);
    }

    public Commands.ApkDescription writeToDiskAsUniversal(ModuleSplit standaloneSplit, Path outputDirectory) {
        return this.writeToDiskInternal(standaloneSplit, outputDirectory, ZipPath.create("universal.apk"));
    }

    public Commands.ApkDescription writeHibernatedApkToDisk(ModuleSplit standaloneSplit, Path outputDirectory, ZipPath apkPath) {
        return this.writeToDiskInternal(standaloneSplit, outputDirectory, apkPath);
    }

    public Commands.ApkDescription writeSystemApkToDisk(ModuleSplit systemSplit, Path outputDirectory, ZipPath apkPath) {
        this.apkSerializerHelper.writeToZipFile(systemSplit, outputDirectory.resolve(apkPath.toString()));
        Commands.ApkDescription.Builder apkDescription = Commands.ApkDescription.newBuilder().setPath(apkPath.toString()).setTargeting(systemSplit.getApkTargeting());
        if (systemSplit.isBaseModuleSplit() && systemSplit.isMasterSplit()) {
            apkDescription.setSystemApkMetadata(Commands.SystemApkMetadata.newBuilder().addAllFusedModuleName((Iterable<String>)systemSplit.getAndroidManifest().getFusedModuleNames()));
        } else {
            apkDescription.setSplitApkMetadata(Commands.SplitApkMetadata.newBuilder().setSplitId(systemSplit.getAndroidManifest().getSplitId().get()).setIsMasterSplit(systemSplit.isMasterSplit()));
        }
        return apkDescription.build();
    }

    @VisibleForTesting
    Commands.ApkDescription writeToDiskInternal(ModuleSplit standaloneSplit, Path outputDirectory, ZipPath apkPath) {
        this.apkSerializerHelper.writeToZipFile(standaloneSplit, outputDirectory.resolve(apkPath.toString()));
        Commands.ApkDescription.Builder apkDescription = Commands.ApkDescription.newBuilder().setPath(apkPath.toString()).setTargeting(standaloneSplit.getApkTargeting());
        if (standaloneSplit.isApex()) {
            apkDescription.setApexApkMetadata(Commands.ApexApkMetadata.newBuilder().addAllApexEmbeddedApkConfig((Iterable<? extends Config.ApexEmbeddedApkConfig>)standaloneSplit.getApexEmbeddedApkConfigs()).build());
        } else if (standaloneSplit.getSplitType() == ModuleSplit.SplitType.HIBERNATION) {
            apkDescription.setHibernatedApkMetadata(Commands.HibernatedApkMetadata.getDefaultInstance());
        } else {
            apkDescription.setStandaloneApkMetadata(Commands.StandaloneApkMetadata.newBuilder().addAllFusedModuleName((Iterable<String>)standaloneSplit.getAndroidManifest().getFusedModuleNames()));
        }
        return apkDescription.build();
    }
}

