/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.io.ByteSource;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import shadow.bundletool.com.android.zipflinger.BytesSource;
import shadow.bundletool.com.android.zipflinger.Source;
import shadow.bundletool.com.android.zipflinger.ZipArchive;
import shadow.bundletool.com.android.zipflinger.ZipSource;

public final class ZipFlingerAppBundleSerializer {
    private static final int DEFAULT_COMPRESSION_LEVEL = 6;

    public void writeToDisk(AppBundle bundle, Path destBundlePath) throws IOException {
        try (ZipArchive zipArchive = new ZipArchive(destBundlePath);){
            zipArchive.add(ZipFlingerAppBundleSerializer.protoToSource(ZipPath.create("BundleConfig.pb"), (MessageLite)bundle.getBundleConfig(), 6));
            if (bundle.getFeatureModules().isEmpty() || !bundle.isApex()) {
                for (Map.Entry metadataEntry : bundle.getBundleMetadata().getFileContentMap().entrySet()) {
                    zipArchive.add(new BytesSource(((ByteSource)metadataEntry.getValue()).read(), AppBundle.METADATA_DIRECTORY.resolve((ZipPath)metadataEntry.getKey()).toString(), 6));
                }
            }
            ZipFlingerAppBundleSerializer.addEntriesFromSourceBundles(zipArchive, ZipFlingerAppBundleSerializer.getUnmodifiedModuleEntries(bundle));
            ZipFlingerAppBundleSerializer.addNewEntries(zipArchive, ZipFlingerAppBundleSerializer.getNewOrModifiedModuleEntries(bundle));
            for (BundleModule module : bundle.getModules().values()) {
                ZipPath moduleDir = ZipPath.create(module.getName().toString());
                zipArchive.add(ZipFlingerAppBundleSerializer.protoToSource(moduleDir.resolve(BundleModule.SpecialModuleEntry.ANDROID_MANIFEST.getPath()), (MessageLite)module.getAndroidManifest().getManifestRoot().getProto(), 6));
                if (module.getAssetsConfig().isPresent()) {
                    zipArchive.add(ZipFlingerAppBundleSerializer.protoToSource(moduleDir.resolve(BundleModule.SpecialModuleEntry.ASSETS_TABLE.getPath()), (MessageLite)module.getAssetsConfig().get(), 6));
                }
                if (module.getNativeConfig().isPresent()) {
                    zipArchive.add(ZipFlingerAppBundleSerializer.protoToSource(moduleDir.resolve(BundleModule.SpecialModuleEntry.NATIVE_LIBS_TABLE.getPath()), (MessageLite)module.getNativeConfig().get(), 6));
                }
                if (module.getResourceTable().isPresent()) {
                    zipArchive.add(ZipFlingerAppBundleSerializer.protoToSource(moduleDir.resolve(BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath()), (MessageLite)module.getResourceTable().get(), 6));
                }
                if (!module.getApexConfig().isPresent()) continue;
                zipArchive.add(ZipFlingerAppBundleSerializer.protoToSource(moduleDir.resolve(BundleModule.SpecialModuleEntry.APEX_TABLE.getPath()), (MessageLite)module.getApexConfig().get(), 6));
            }
        }
    }

    @VisibleForTesting
    static ImmutableListMultimap<BundleModule, ModuleEntry> getUnmodifiedModuleEntries(AppBundle bundle) {
        return (ImmutableListMultimap)bundle.getModules().values().stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(module -> module, module -> module.getEntries().stream().filter(entry -> entry.getBundleLocation().isPresent())));
    }

    private static ImmutableListMultimap<BundleModule, ModuleEntry> getNewOrModifiedModuleEntries(AppBundle bundle) {
        return (ImmutableListMultimap)bundle.getModules().values().stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(module -> module, module -> module.getEntries().stream().filter(entry -> !entry.getBundleLocation().isPresent())));
    }

    private static void addEntriesFromSourceBundles(ZipArchive archive, ImmutableListMultimap<BundleModule, ModuleEntry> entries) throws IOException {
        HashMap<Path, ZipSource> bundleSources = new HashMap<Path, ZipSource>();
        for (Map.Entry moduleAndEntry : entries.entries()) {
            BundleModule module = (BundleModule)moduleAndEntry.getKey();
            ModuleEntry moduleEntry = (ModuleEntry)moduleAndEntry.getValue();
            ModuleEntry.ModuleEntryBundleLocation location = moduleEntry.getBundleLocation().orElseThrow(IllegalStateException::new);
            ZipPath entryFullPathInSourceBundle = location.entryPathInBundle();
            ZipPath moduleDir = ZipPath.create(module.getName().toString());
            ZipPath entryFullPathInDestBundle = moduleDir.resolve(moduleEntry.getPath());
            Path pathToBundle = location.pathToBundle();
            ZipSource entrySource = bundleSources.containsKey(pathToBundle) ? (ZipSource)bundleSources.get(pathToBundle) : new ZipSource(pathToBundle);
            bundleSources.putIfAbsent(pathToBundle, entrySource);
            entrySource.select(entryFullPathInSourceBundle.toString(), entryFullPathInDestBundle.toString());
        }
        for (ZipSource source : bundleSources.values()) {
            archive.add(source);
        }
    }

    private static void addNewEntries(ZipArchive archive, ImmutableListMultimap<BundleModule, ModuleEntry> entries) throws IOException {
        for (Map.Entry moduleAndEntry : entries.entries()) {
            BundleModule module = (BundleModule)moduleAndEntry.getKey();
            ModuleEntry moduleEntry = (ModuleEntry)moduleAndEntry.getValue();
            Preconditions.checkState((!moduleEntry.getBundleLocation().isPresent() ? 1 : 0) != 0);
            ZipPath moduleDir = ZipPath.create(module.getName().toString());
            ZipPath destPath = moduleDir.resolve(moduleEntry.getPath());
            archive.add(new BytesSource(moduleEntry.getContent().read(), destPath.toString(), 6));
        }
    }

    private static Source protoToSource(ZipPath path, MessageLite proto, int compression) throws IOException {
        return new BytesSource(proto.toByteArray(), path.toString(), compression);
    }
}

