/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.shards;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.android.tools.build.bundletool.shards.BundleModule64BitNativeLibrariesRemover;
import com.android.tools.build.bundletool.shards.StandaloneApexApksGenerator;
import com.android.tools.build.bundletool.shards.StandaloneApksGenerator;
import com.android.tools.build.bundletool.shards.SystemApksGenerator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import javax.inject.Inject;

public final class ShardedApksFacade {
    private final StandaloneApksGenerator standaloneApksGenerator;
    private final StandaloneApexApksGenerator standaloneApexApksGenerator;
    private final SystemApksGenerator systemApksGenerator;
    private final BundleModule64BitNativeLibrariesRemover bundleModule64BitNativeLibrariesRemover;
    private final Config.BundleConfig bundleConfig;
    private final BuildApksCommand.ApkBuildMode apkBuildMode;

    @Inject
    public ShardedApksFacade(StandaloneApksGenerator standaloneApksGenerator, StandaloneApexApksGenerator standaloneApexApksGenerator, SystemApksGenerator systemApksGenerator, BundleModule64BitNativeLibrariesRemover bundleModule64BitNativeLibrariesRemover, Config.BundleConfig bundleConfig, BuildApksCommand.ApkBuildMode apkBuildMode) {
        this.standaloneApksGenerator = standaloneApksGenerator;
        this.standaloneApexApksGenerator = standaloneApexApksGenerator;
        this.systemApksGenerator = systemApksGenerator;
        this.bundleModule64BitNativeLibrariesRemover = bundleModule64BitNativeLibrariesRemover;
        this.bundleConfig = bundleConfig;
        this.apkBuildMode = apkBuildMode;
    }

    public ImmutableList<ModuleSplit> generateSplits(ImmutableList<BundleModule> modules, ApkOptimizations apkOptimizations) {
        return this.standaloneApksGenerator.generateStandaloneApks(this.maybeRemove64BitLibraries(modules), apkOptimizations);
    }

    public ImmutableList<ModuleSplit> generateSystemSplits(ImmutableList<BundleModule> modules, ImmutableSet<BundleModuleName> modulesToFuse, ApkOptimizations apkOptimizations) {
        return this.systemApksGenerator.generateSystemApks(this.maybeRemove64BitLibraries(modules), modulesToFuse, apkOptimizations);
    }

    public ImmutableList<ModuleSplit> generateApexSplits(ImmutableList<BundleModule> modules) {
        return this.standaloneApexApksGenerator.generateStandaloneApks(this.maybeRemove64BitLibraries(modules));
    }

    private ImmutableList<BundleModule> maybeRemove64BitLibraries(ImmutableList<BundleModule> modules) {
        boolean shouldStrip64BitLibraries;
        boolean bl = shouldStrip64BitLibraries = this.bundleConfig.getOptimizations().getStandaloneConfig().getStrip64BitLibraries() && !this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.UNIVERSAL);
        if (!shouldStrip64BitLibraries) {
            return modules;
        }
        return (ImmutableList)modules.stream().map(this.bundleModule64BitNativeLibrariesRemover::strip64BitLibraries).collect(ImmutableList.toImmutableList());
    }
}

