/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.ApiObjectFactory;
import com.android.build.gradle.internal.BadPluginException;
import com.android.build.gradle.internal.DependencyManager;
import com.android.build.gradle.internal.ExecutionConfigurationUtil;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.LibraryCache;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.NativeLibraryFactoryImpl;
import com.android.build.gradle.internal.NonFinalPluginExpiry;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.TaskContainerAdaptor;
import com.android.build.gradle.internal.TaskFactory;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.ToolingRegistryProvider;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.Version;
import com.android.build.gradle.internal.coverage.JacocoPlugin;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.BuildTypeFactory;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.ProductFlavorFactory;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.dsl.SigningConfigFactory;
import com.android.build.gradle.internal.ide.ModelBuilder;
import com.android.build.gradle.internal.ide.NativeModelBuilder;
import com.android.build.gradle.internal.model.NativeLibraryFactory;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.pipeline.TransformTask;
import com.android.build.gradle.internal.process.GradleJavaProcessExecutor;
import com.android.build.gradle.internal.process.GradleProcessExecutor;
import com.android.build.gradle.internal.profile.ProfilerInitializer;
import com.android.build.gradle.internal.transforms.DexTransform;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.tasks.ExternalNativeBuildTaskUtils;
import com.android.build.gradle.tasks.ExternalNativeJsonGenerator;
import com.android.build.gradle.tasks.JackPreDexTransform;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.ErrorReporter;
import com.android.builder.internal.compiler.JackConversionCache;
import com.android.builder.internal.compiler.PreDexCache;
import com.android.builder.model.DataBindingOptions;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.builder.profile.Recorder;
import com.android.builder.profile.ThreadRecorder;
import com.android.builder.sdk.SdkLibData;
import com.android.builder.sdk.TargetInfo;
import com.android.dx.command.dexer.Main;
import com.android.ide.common.internal.ExecutorSingleton;
import com.android.ide.common.process.JavaProcessExecutor;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.repository.GradleVersion;
import com.android.repository.api.Channel;
import com.android.repository.api.Downloader;
import com.android.repository.api.SettingsController;
import com.android.repository.impl.downloader.LocalFileAwareDownloader;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.repository.legacy.LegacyDownloader;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.wireless.android.sdk.stats.GradleBuildProfileSpan;
import com.google.wireless.android.sdk.stats.GradleBuildProject;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public abstract class BasePlugin
implements ToolingRegistryProvider {
    public static final GradleVersion GRADLE_MIN_VERSION = GradleVersion.parse((String)"3.3");
    private BaseExtension extension;
    private VariantManager variantManager;
    private TaskManager taskManager;
    private Project project;
    private SdkHandler sdkHandler;
    private NdkHandler ndkHandler;
    private AndroidBuilder androidBuilder;
    private DataBindingBuilder dataBindingBuilder;
    private Instantiator instantiator;
    private VariantFactory variantFactory;
    private ToolingModelBuilderRegistry registry;
    private LoggerWrapper loggerWrapper;
    private ExtraModelInfo extraModelInfo;
    private String creator;
    private DependencyManager dependencyManager;
    private Recorder threadRecorder;
    private boolean hasCreatedTasks = false;

    BasePlugin(Instantiator instantiator, ToolingModelBuilderRegistry registry) {
        this.instantiator = instantiator;
        this.registry = registry;
        this.creator = "Android Gradle " + com.android.builder.Version.ANDROID_GRADLE_PLUGIN_VERSION;
        NonFinalPluginExpiry.verifyRetirementAge();
        ModelBuilder.clearCaches();
    }

    protected abstract BaseExtension createExtension(Project var1, Instantiator var2, AndroidBuilder var3, SdkHandler var4, NamedDomainObjectContainer<BuildType> var5, NamedDomainObjectContainer<ProductFlavor> var6, NamedDomainObjectContainer<SigningConfig> var7, ExtraModelInfo var8);

    protected abstract GradleBuildProject.PluginType getAnalyticsPluginType();

    protected abstract VariantFactory createVariantFactory(Instantiator var1, AndroidBuilder var2, AndroidConfig var3);

    protected abstract TaskManager createTaskManager(Project var1, AndroidBuilder var2, DataBindingBuilder var3, AndroidConfig var4, SdkHandler var5, NdkHandler var6, DependencyManager var7, ToolingModelBuilderRegistry var8, Recorder var9);

    protected abstract int getProjectType();

    public VariantManager getVariantManager() {
        return this.variantManager;
    }

    BaseExtension getExtension() {
        return this.extension;
    }

    AndroidBuilder getAndroidBuilder() {
        return this.androidBuilder;
    }

    private ILogger getLogger() {
        if (this.loggerWrapper == null) {
            this.loggerWrapper = new LoggerWrapper(this.project.getLogger());
        }
        return this.loggerWrapper;
    }

    protected void apply(Project project) {
        BasePlugin.checkPluginVersion();
        this.project = project;
        ExecutionConfigurationUtil.setThreadPoolSize((Project)project);
        this.checkPathForErrors();
        this.checkModulesForErrors();
        ProfilerInitializer.init((Project)project);
        this.threadRecorder = ThreadRecorder.get();
        ProcessProfileWriter.getProject((String)project.getPath()).setAndroidPluginVersion(com.android.builder.Version.ANDROID_GRADLE_PLUGIN_VERSION).setAndroidPlugin(this.getAnalyticsPluginType()).setPluginGeneration(GradleBuildProject.PluginGeneration.FIRST);
        this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_CONFIGURE, project.getPath(), null, this::configureProject);
        this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_BASE_EXTENSION_CREATION, project.getPath(), null, this::configureExtension);
        this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_PROJECT_TASKS_CREATION, project.getPath(), null, this::createTasks);
        for (String plugin : AndroidGradleOptions.getAdditionalPlugins((Project)project)) {
            project.apply((Map)ImmutableMap.of((Object)"plugin", (Object)plugin));
        }
    }

    private void configureProject() {
        this.extraModelInfo = new ExtraModelInfo(this.project);
        this.checkGradleVersion();
        AndroidGradleOptions.validate((Project)this.project);
        this.sdkHandler = new SdkHandler(this.project, this.getLogger());
        this.project.afterEvaluate(p -> {
            if (!p.getGradle().getStartParameter().isOffline() && AndroidGradleOptions.getUseSdkDownload((Project)p)) {
                SdkLibData sdkLibData = SdkLibData.download((Downloader)this.getDownloader(), (SettingsController)this.getSettingsController());
                this.dependencyManager.setSdkLibData(sdkLibData);
                this.sdkHandler.setSdkLibData(sdkLibData);
            }
        });
        this.androidBuilder = new AndroidBuilder(this.project == this.project.getRootProject() ? this.project.getName() : this.project.getPath(), this.creator, (ProcessExecutor)new GradleProcessExecutor(this.project), (JavaProcessExecutor)new GradleJavaProcessExecutor(this.project), (ErrorReporter)this.extraModelInfo, this.getLogger(), this.isVerbose());
        this.dataBindingBuilder = new DataBindingBuilder();
        this.dataBindingBuilder.setPrintMachineReadableOutput(this.extraModelInfo.getErrorFormatMode() == ExtraModelInfo.ErrorFormatMode.MACHINE_PARSABLE);
        this.project.getPlugins().apply(JavaBasePlugin.class);
        this.project.getPlugins().apply(JacocoPlugin.class);
        this.project.getTasks().getByName("assemble").setDescription("Assembles all variants of all applications and secondary packages.");
        this.project.getGradle().addBuildListener(new BuildListener(){
            private final LibraryCache libraryCache = LibraryCache.getCache();

            public void buildStarted(Gradle gradle) {
            }

            public void settingsEvaluated(Settings settings) {
            }

            public void projectsLoaded(Gradle gradle) {
            }

            public void projectsEvaluated(Gradle gradle) {
            }

            public void buildFinished(BuildResult buildResult) {
                ExecutorSingleton.shutdown();
                BasePlugin.this.sdkHandler.unload();
                BasePlugin.this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_BUILD_FINISHED, BasePlugin.this.project.getPath(), null, () -> {
                    PreDexCache.getCache().clear(FileUtils.join((File)BasePlugin.this.project.getRootProject().getBuildDir(), (String[])new String[]{"intermediates", "dex-cache", "cache.xml"}), BasePlugin.this.getLogger());
                    JackConversionCache.getCache().clear(FileUtils.join((File)BasePlugin.this.project.getRootProject().getBuildDir(), (String[])new String[]{"intermediates", "jack-cache", "cache.xml"}), BasePlugin.this.getLogger());
                    this.libraryCache.unload();
                    Main.clearInternTables();
                });
            }
        });
        this.project.getGradle().getTaskGraph().addTaskExecutionGraphListener(taskGraph -> {
            for (Task task : taskGraph.getAllTasks()) {
                if (!(task instanceof TransformTask)) continue;
                Transform transform = ((TransformTask)task).getTransform();
                if (transform instanceof DexTransform) {
                    PreDexCache.getCache().load(FileUtils.join((File)this.project.getRootProject().getBuildDir(), (String[])new String[]{"intermediates", "dex-cache", "cache.xml"}));
                    break;
                }
                if (!(transform instanceof JackPreDexTransform)) continue;
                JackConversionCache.getCache().load(FileUtils.join((File)this.project.getRootProject().getBuildDir(), (String[])new String[]{"intermediates", "jack-cache", "cache.xml"}));
                break;
            }
        });
    }

    private void configureExtension() {
        NamedDomainObjectContainer buildTypeContainer = this.project.container(BuildType.class, (NamedDomainObjectFactory)new BuildTypeFactory(this.instantiator, this.project, this.project.getLogger()));
        NamedDomainObjectContainer productFlavorContainer = this.project.container(ProductFlavor.class, (NamedDomainObjectFactory)new ProductFlavorFactory(this.instantiator, this.project, this.project.getLogger(), (ErrorReporter)this.extraModelInfo));
        NamedDomainObjectContainer signingConfigContainer = this.project.container(SigningConfig.class, (NamedDomainObjectFactory)new SigningConfigFactory(this.instantiator));
        this.extension = this.createExtension(this.project, this.instantiator, this.androidBuilder, this.sdkHandler, (NamedDomainObjectContainer<BuildType>)buildTypeContainer, (NamedDomainObjectContainer<ProductFlavor>)productFlavorContainer, (NamedDomainObjectContainer<SigningConfig>)signingConfigContainer, this.extraModelInfo);
        ((Configuration)this.project.getConfigurations().create("default-mapping")).setDescription("Configuration for default mapping artifacts.");
        ((Configuration)this.project.getConfigurations().create("default-metadata")).setDescription("Metadata for the produced APKs.");
        this.dependencyManager = new DependencyManager(this.project, this.extraModelInfo, this.sdkHandler);
        this.ndkHandler = new NdkHandler(this.project.getRootDir(), null, "gcc", "");
        this.taskManager = this.createTaskManager(this.project, this.androidBuilder, this.dataBindingBuilder, this.extension, this.sdkHandler, this.ndkHandler, this.dependencyManager, this.registry, this.threadRecorder);
        this.variantFactory = this.createVariantFactory(this.instantiator, this.androidBuilder, this.extension);
        this.variantManager = new VariantManager(this.project, this.androidBuilder, (AndroidConfig)this.extension, this.variantFactory, this.taskManager, this.instantiator, this.threadRecorder);
        ModelBuilder modelBuilder = new ModelBuilder(this.androidBuilder, this.variantManager, this.taskManager, (AndroidConfig)this.extension, this.extraModelInfo, this.ndkHandler, (NativeLibraryFactory)new NativeLibraryFactoryImpl(this.ndkHandler), this.getProjectType(), 1);
        this.registry.register((ToolingModelBuilder)modelBuilder);
        NativeModelBuilder nativeModelBuilder = new NativeModelBuilder(this.variantManager);
        this.registry.register((ToolingModelBuilder)nativeModelBuilder);
        signingConfigContainer.whenObjectAdded(arg_0 -> ((VariantManager)this.variantManager).addSigningConfig(arg_0));
        buildTypeContainer.whenObjectAdded(buildType -> {
            SigningConfig signingConfig = (SigningConfig)signingConfigContainer.findByName("debug");
            buildType.init(signingConfig);
            this.variantManager.addBuildType((CoreBuildType)buildType);
        });
        productFlavorContainer.whenObjectAdded(arg_0 -> ((VariantManager)this.variantManager).addProductFlavor(arg_0));
        signingConfigContainer.whenObjectRemoved((Action)new UnsupportedAction("Removing signingConfigs is not supported."));
        buildTypeContainer.whenObjectRemoved((Action)new UnsupportedAction("Removing build types is not supported."));
        productFlavorContainer.whenObjectRemoved((Action)new UnsupportedAction("Removing product flavors is not supported."));
        this.variantFactory.createDefaultComponents(buildTypeContainer, productFlavorContainer, signingConfigContainer);
    }

    private void createTasks() {
        this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.TASK_MANAGER_CREATE_TASKS, this.project.getPath(), null, () -> this.taskManager.createTasksBeforeEvaluate((TaskFactory)new TaskContainerAdaptor(this.project.getTasks())));
        this.project.afterEvaluate(project -> this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.BASE_PLUGIN_CREATE_ANDROID_TASKS, project.getPath(), null, () -> this.createAndroidTasks(false)));
    }

    private void checkGradleVersion() {
        String currentVersion = this.project.getGradle().getGradleVersion();
        if (GRADLE_MIN_VERSION.compareTo(currentVersion) > 0) {
            File file = new File("gradle" + File.separator + "wrapper" + File.separator + "gradle-wrapper.properties");
            String errorMessage = String.format("Minimum supported Gradle version is %s. Current version is %s. If using the gradle wrapper, try editing the distributionUrl in %s to gradle-%s-all.zip", GRADLE_MIN_VERSION, currentVersion, file.getAbsolutePath(), GRADLE_MIN_VERSION);
            if (AndroidGradleOptions.overrideGradleVersionCheck((Project)this.project)) {
                this.getLogger().warning(errorMessage, new Object[0]);
                this.getLogger().warning("As %s is set, continuing anyways.", new Object[]{"android.overrideVersionCheck"});
            } else {
                throw new RuntimeException(errorMessage);
            }
        }
    }

    final void createAndroidTasks(boolean force) {
        Preconditions.checkState((this.extension.getBuildToolsRevision() != null ? 1 : 0) != 0, (Object)"buildToolsVersion is not specified.");
        Preconditions.checkState((this.extension.getCompileSdkVersion() != null ? 1 : 0) != 0, (Object)"compileSdkVersion is not specified.");
        this.ndkHandler.setCompileSdkVersion(this.extension.getCompileSdkVersion());
        if (this.project.getPlugins().hasPlugin(JavaPlugin.class)) {
            throw new BadPluginException("The 'java' plugin has been applied, but it is not compatible with the Android plugins.");
        }
        this.ensureTargetSetup();
        if (!(force || this.project.getState().getExecuted() && this.project.getState().getFailure() == null || SdkHandler.sTestSdkFolder != null)) {
            return;
        }
        if (this.hasCreatedTasks) {
            return;
        }
        this.hasCreatedTasks = true;
        this.extension.disableWrite();
        ProcessProfileWriter.getProject((String)this.project.getPath()).setBuildToolsVersion(this.extension.getBuildToolsRevision().toString());
        this.sdkHandler.addLocalRepositories(this.project);
        this.taskManager.addDataBindingDependenciesIfNecessary((DataBindingOptions)this.extension.getDataBinding());
        this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.VARIANT_MANAGER_CREATE_ANDROID_TASKS, this.project.getPath(), null, () -> {
            this.variantManager.createAndroidTasks();
            ApiObjectFactory apiObjectFactory = new ApiObjectFactory(this.androidBuilder, this.extension, this.variantFactory, this.instantiator);
            for (BaseVariantData variantData : this.variantManager.getVariantDataList()) {
                apiObjectFactory.create(variantData);
            }
        });
        boolean forceRegeneration = AndroidGradleOptions.refreshExternalNativeModel((Project)this.project);
        if (ExternalNativeBuildTaskUtils.shouldRegenerateOutOfDateJsons((Project)this.project)) {
            this.threadRecorder.record(GradleBuildProfileSpan.ExecutionType.VARIANT_MANAGER_EXTERNAL_NATIVE_CONFIG_VALUES, this.project.getPath(), null, () -> {
                for (BaseVariantData variantData : this.variantManager.getVariantDataList()) {
                    ExternalNativeJsonGenerator generator = variantData.getScope().getExternalNativeJsonGenerator();
                    if (generator == null) continue;
                    generator.build(forceRegeneration);
                    variantData.getScope().addExternalNativeBuildConfigValues(generator.readExistingNativeBuildConfigurations());
                }
            });
        }
    }

    private boolean isVerbose() {
        return this.project.getLogger().isEnabled(LogLevel.INFO);
    }

    private void ensureTargetSetup() {
        TargetInfo targetInfo = this.androidBuilder.getTargetInfo();
        if (targetInfo == null) {
            if (this.extension.getCompileOptions() == null) {
                throw new GradleException("Calling getBootClasspath before compileSdkVersion");
            }
            this.sdkHandler.initTarget(this.extension.getCompileSdkVersion(), this.extension.getBuildToolsRevision(), this.extension.getLibraryRequests(), this.androidBuilder, SdkHandler.useCachedSdk((Project)this.project));
        }
    }

    private void checkModulesForErrors() {
        Project rootProject = this.project.getRootProject();
        HashMap<String, Project> subProjectsById = new HashMap<String, Project>();
        for (Project subProject : rootProject.getAllprojects()) {
            String id = subProject.getGroup().toString() + ":" + subProject.getName();
            if (subProjectsById.containsKey(id)) {
                String message = String.format("Your project contains 2 or more modules with the same identification %1$s\nat \"%2$s\" and \"%3$s\".\nYou must use different identification (either name or group) for each modules.", id, ((Project)subProjectsById.get(id)).getPath(), subProject.getPath());
                throw new StopExecutionException(message);
            }
            subProjectsById.put(id, subProject);
        }
    }

    private static void checkPluginVersion() {
        String actualGradlePluginVersion = com.android.builder.Version.ANDROID_GRADLE_PLUGIN_VERSION;
        if (!actualGradlePluginVersion.equals(Version.ANDROID_GRADLE_PLUGIN_VERSION)) {
            throw new UnsupportedVersionException(String.format("Plugin version mismatch.  'com.android.tools.build:gradle-experimental:%s' was applied, and it requires 'com.android.tools.build:gradle:%s'.  Current version is '%s'.  Please update to version '%s'.", com.android.builder.Version.ANDROID_GRADLE_COMPONENT_PLUGIN_VERSION, com.android.builder.Version.ANDROID_GRADLE_PLUGIN_VERSION, Version.ANDROID_GRADLE_PLUGIN_VERSION, com.android.builder.Version.ANDROID_GRADLE_PLUGIN_VERSION));
        }
    }

    private void checkPathForErrors() {
        if (!System.getProperty("os.name").toLowerCase(Locale.US).contains("windows")) {
            return;
        }
        if (AndroidGradleOptions.overridePathCheck((Project)this.project)) {
            return;
        }
        if (CharMatcher.ASCII.matchesAllOf((CharSequence)this.project.getRootDir().getAbsolutePath())) {
            return;
        }
        String message = "Your project path contains non-ASCII characters. This will most likely cause the build to fail on Windows. Please move your project to a different directory. See http://b.android.com/95744 for details. This warning can be disabled by adding the line 'android.overridePathCheck=true' to gradle.properties file in the project directory.";
        throw new StopExecutionException(message);
    }

    public ToolingModelBuilderRegistry getModelBuilderRegistry() {
        return this.registry;
    }

    private SettingsController getSettingsController() {
        return new SettingsController(){

            public boolean getForceHttp() {
                return false;
            }

            public void setForceHttp(boolean force) {
            }

            public Channel getChannel() {
                return AndroidGradleOptions.getSdkChannel((Project)BasePlugin.this.project);
            }
        };
    }

    private Downloader getDownloader() {
        return new LocalFileAwareDownloader((Downloader)new LegacyDownloader(FileOpUtils.create(), this.getSettingsController()));
    }

    private static class UnsupportedAction
    implements Action<Object> {
        private final String message;

        UnsupportedAction(String message) {
            this.message = message;
        }

        public void execute(Object o) {
            throw new UnsupportedOperationException(this.message);
        }
    }
}

