/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.tasks.ModuleInfoAdapter;
import com.android.utils.FileUtils;
import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\r\u001a\u00020\u00002\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/android/build/gradle/internal/tasks/ModuleInfo;", "", "path", "", "pluginName", "hasKotlin", "", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getHasKotlin", "()Z", "getPath", "()Ljava/lang/String;", "getPluginName", "anonymize", "nameMap", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "save", "", "to", "Ljava/io/File;", "toString", "gradle"})
public final class ModuleInfo {
    @NotNull
    private final String path;
    @NotNull
    private final String pluginName;
    private final boolean hasKotlin;

    public final void save(@NotNull File to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)ModuleInfo.class), (Object)new ModuleInfoAdapter()).create();
        FileUtils.mkdirs((File)to.getParentFile());
        Files.asCharSink((File)to, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)gson.toJson((Object)this));
    }

    @NotNull
    public final ModuleInfo anonymize(@NotNull Map<String, String> nameMap) {
        Intrinsics.checkParameterIsNotNull(nameMap, (String)"nameMap");
        String string = nameMap.get(this.path);
        if (string == null) {
            throw (Throwable)new RuntimeException("Can't find new name for " + this.path);
        }
        String newPath = string;
        return new ModuleInfo(newPath, this.pluginName, this.hasKotlin);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getPluginName() {
        return this.pluginName;
    }

    public final boolean getHasKotlin() {
        return this.hasKotlin;
    }

    public ModuleInfo(@NotNull String path, @NotNull String pluginName, boolean hasKotlin) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)pluginName, (String)"pluginName");
        this.path = path;
        this.pluginName = pluginName;
        this.hasKotlin = hasKotlin;
    }

    @NotNull
    public final String component1() {
        return this.path;
    }

    @NotNull
    public final String component2() {
        return this.pluginName;
    }

    public final boolean component3() {
        return this.hasKotlin;
    }

    @NotNull
    public final ModuleInfo copy(@NotNull String path, @NotNull String pluginName, boolean hasKotlin) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)pluginName, (String)"pluginName");
        return new ModuleInfo(path, pluginName, hasKotlin);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ModuleInfo copy$default(ModuleInfo moduleInfo, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = moduleInfo.path;
        }
        if ((n & 2) != 0) {
            string2 = moduleInfo.pluginName;
        }
        if ((n & 4) != 0) {
            bl = moduleInfo.hasKotlin;
        }
        return moduleInfo.copy(string, string2, bl);
    }

    public String toString() {
        return "ModuleInfo(path=" + this.path + ", pluginName=" + this.pluginName + ", hasKotlin=" + this.hasKotlin + ")";
    }

    public int hashCode() {
        String string = this.path;
        String string2 = this.pluginName;
        int n = ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31;
        int n2 = this.hasKotlin ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        return n + n2;
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ModuleInfo)) break block3;
                ModuleInfo moduleInfo = (ModuleInfo)object;
                if (!Intrinsics.areEqual((Object)this.path, (Object)moduleInfo.path) || !Intrinsics.areEqual((Object)this.pluginName, (Object)moduleInfo.pluginName) || !(this.hasKotlin == moduleInfo.hasKotlin)) break block3;
            }
            return true;
        }
        return false;
    }
}

