/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.pipeline;

import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.gradle.internal.pipeline.ImmutableDirectoryInput;
import com.android.build.gradle.internal.pipeline.ImmutableJarInput;
import com.android.build.gradle.internal.pipeline.ImmutableTransformInput;
import com.android.build.gradle.internal.pipeline.IncrementalTransformInput;
import com.android.build.gradle.internal.pipeline.MutableDirectoryInput;
import com.android.build.gradle.internal.pipeline.QualifiedContentImpl;
import com.android.build.gradle.internal.pipeline.TransformStream;
import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;

public class OriginalStream
extends TransformStream {
    public static final String LOCAL_JAR_GROUPID = "android.local.jars:";
    private final ArtifactCollection artifactCollection;

    public static Builder builder(Project project, String name) {
        return new Builder(project, name);
    }

    private OriginalStream(String name, Set<QualifiedContent.ContentType> contentTypes, QualifiedContent.ScopeType scope, ArtifactCollection artifactCollection, FileCollection files) {
        super(name, contentTypes, (Set<? super QualifiedContent.Scope>)ImmutableSet.of((Object)scope), files);
        this.artifactCollection = artifactCollection;
    }

    @Override
    TransformInput asNonIncrementalInput() {
        List<Object> directoryInputs;
        List<Object> jarInputs;
        Set<QualifiedContent.ContentType> contentTypes = this.getContentTypes();
        Set<? super QualifiedContent.Scope> scopes = this.getScopes();
        if (this.artifactCollection != null) {
            jarInputs = Lists.newArrayList();
            directoryInputs = Lists.newArrayList();
            HashMap duplicates = Maps.newHashMap();
            for (ResolvedArtifactResult result : this.artifactCollection.getArtifacts()) {
                File artifactFile = result.getFile();
                if (artifactFile.isFile()) {
                    jarInputs.add(new ImmutableJarInput(OriginalStream.getArtifactName(result, duplicates), artifactFile, Status.NOTCHANGED, contentTypes, scopes));
                    continue;
                }
                if (!artifactFile.isDirectory()) continue;
                directoryInputs.add(new ImmutableDirectoryInput(OriginalStream.getArtifactName(result, duplicates), artifactFile, contentTypes, scopes));
            }
        } else {
            Set files = this.getFileCollection().getFiles();
            jarInputs = files.stream().filter(File::isFile).map(file -> new ImmutableJarInput(OriginalStream.getUniqueInputName(file), (File)file, Status.NOTCHANGED, contentTypes, scopes)).collect(Collectors.toList());
            directoryInputs = files.stream().filter(File::isDirectory).map(file -> new ImmutableDirectoryInput(OriginalStream.getUniqueInputName(file), (File)file, contentTypes, scopes)).collect(Collectors.toList());
        }
        return new ImmutableTransformInput((Collection<JarInput>)jarInputs, directoryInputs, null);
    }

    @Override
    IncrementalTransformInput asIncrementalInput() {
        OriginalTransformInput input = new OriginalTransformInput();
        Set<QualifiedContent.ContentType> contentTypes = this.getContentTypes();
        Set<? super QualifiedContent.Scope> scopes = this.getScopes();
        if (this.artifactCollection != null) {
            HashMap duplicates = Maps.newHashMap();
            for (ResolvedArtifactResult result : this.artifactCollection.getArtifacts()) {
                File artifactFile = result.getFile();
                if (artifactFile.isDirectory()) {
                    input.addFolderInput(new MutableDirectoryInput(OriginalStream.getArtifactName(result, duplicates), artifactFile, contentTypes, scopes));
                    continue;
                }
                if (!artifactFile.isFile()) continue;
                input.addJarInput(new QualifiedContentImpl(OriginalStream.getArtifactName(result, duplicates), artifactFile, contentTypes, scopes));
            }
        } else {
            this.getFileCollection().getFiles().forEach(file -> {
                if (file.isDirectory()) {
                    input.addFolderInput(new MutableDirectoryInput(OriginalStream.getUniqueInputName(file), (File)file, contentTypes, scopes));
                } else if (file.isFile()) {
                    input.addJarInput(new QualifiedContentImpl(OriginalStream.getUniqueInputName(file), (File)file, contentTypes, scopes));
                }
            });
        }
        return input;
    }

    private static String getArtifactName(ResolvedArtifactResult artifactResult, Map<ComponentIdentifier, Integer> deduplicationMap) {
        String baseName;
        ComponentIdentifier id = artifactResult.getId().getComponentIdentifier();
        if (id instanceof ProjectComponentIdentifier) {
            baseName = ((ProjectComponentIdentifier)id).getProjectPath();
        } else if (id instanceof ModuleComponentIdentifier) {
            baseName = id.getDisplayName();
        } else {
            File artifactFile = artifactResult.getFile();
            baseName = LOCAL_JAR_GROUPID + artifactFile.getName() + ":" + Hashing.sha1().hashString((CharSequence)artifactFile.getPath(), Charsets.UTF_16LE).toString();
        }
        Integer zero = 0;
        Integer i = deduplicationMap.compute(id, (componentIdentifier, value) -> {
            if (value == null) {
                return zero;
            }
            return value + 1;
        });
        if (!zero.equals(i)) {
            return baseName + "::" + i;
        }
        return baseName;
    }

    private static String getUniqueInputName(File file) {
        return Hashing.sha1().hashString((CharSequence)file.getPath(), Charsets.UTF_16LE).toString();
    }

    @Override
    TransformStream makeRestrictedCopy(Set<QualifiedContent.ContentType> types, Set<? super QualifiedContent.Scope> scopes) {
        if (!scopes.equals(this.getScopes())) {
            throw new UnsupportedOperationException("Cannot do a scope-restricted OriginalStream");
        }
        return new OriginalStream(this.getName() + "-restricted-copy", types, (QualifiedContent.ScopeType)Iterables.getOnlyElement(scopes), this.artifactCollection, this.getFileCollection());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("scopes", this.getScopes()).add("contentTypes", this.getContentTypes()).add("fileCollection", (Object)this.getFileCollection()).toString();
    }

    private static class OriginalTransformInput
    extends IncrementalTransformInput {
        private OriginalTransformInput() {
        }

        @Override
        protected boolean checkRemovedFolder(Set<? super QualifiedContent.Scope> transformScopes, Set<QualifiedContent.ContentType> transformInputTypes, File file, List<String> fileSegments) {
            return false;
        }

        @Override
        boolean checkRemovedJarFile(Set<? super QualifiedContent.Scope> transformScopes, Set<QualifiedContent.ContentType> transformInputTypes, File file, List<String> fileSegments) {
            return false;
        }
    }

    public static final class Builder {
        private final Project project;
        private final String name;
        private Set<QualifiedContent.ContentType> contentTypes = Sets.newHashSet();
        private QualifiedContent.ScopeType scope;
        private FileCollection fileCollection;
        private Supplier<Collection<File>> jarFiles;
        private Supplier<Collection<File>> folders;
        private ImmutableList<? extends Object> dependencies;
        private ArtifactCollection artifactCollection;

        public Builder(Project project, String name) {
            this.project = project;
            this.name = name;
        }

        public OriginalStream build() {
            FileCollection fc;
            Preconditions.checkNotNull((Object)this.scope);
            Preconditions.checkState((!this.contentTypes.isEmpty() ? 1 : 0) != 0);
            if (this.fileCollection != null) {
                fc = this.fileCollection;
            } else if (this.artifactCollection != null) {
                fc = this.artifactCollection.getArtifactFiles();
            } else {
                ConfigurableFileCollection fc2 = this.project.files(new Object[]{() -> {
                    if (this.jarFiles != null && this.folders != null) {
                        return ImmutableList.of(this.jarFiles.get(), this.folders.get());
                    }
                    if (this.jarFiles != null) {
                        return this.jarFiles.get();
                    }
                    if (this.folders != null) {
                        return this.folders.get();
                    }
                    return ImmutableList.of();
                }});
                if (this.dependencies != null) {
                    fc2.builtBy(this.dependencies.toArray());
                }
                fc = fc2;
            }
            return new OriginalStream(this.name, (Set)ImmutableSet.copyOf(this.contentTypes), this.scope, this.artifactCollection, fc);
        }

        public Builder addContentTypes(Set<QualifiedContent.ContentType> types) {
            this.contentTypes.addAll(types);
            return this;
        }

        public Builder addContentTypes(QualifiedContent.ContentType ... types) {
            this.contentTypes.addAll(Arrays.asList(types));
            return this;
        }

        public Builder addContentType(QualifiedContent.ContentType type) {
            this.contentTypes.add(type);
            return this;
        }

        public Builder addScope(QualifiedContent.ScopeType scope) {
            this.scope = scope;
            return this;
        }

        @Deprecated
        public Builder setJar(File jarFile) {
            Preconditions.checkState((this.fileCollection == null && this.artifactCollection == null ? 1 : 0) != 0, (Object)"Cannot set file collection, artifact collection and jars/folders at the same time");
            this.jarFiles = () -> ImmutableList.of((Object)jarFile);
            return this;
        }

        @Deprecated
        public Builder setJars(Supplier<Collection<File>> jarSupplier) {
            Preconditions.checkState((this.fileCollection == null && this.artifactCollection == null ? 1 : 0) != 0, (Object)"Cannot set file collection, artifact collection and jars/folders at the same time");
            this.jarFiles = jarSupplier;
            return this;
        }

        @Deprecated
        public Builder setFolder(File folder) {
            Preconditions.checkState((this.fileCollection == null && this.artifactCollection == null ? 1 : 0) != 0, (Object)"Cannot set file collection, artifact collection and jars/folders at the same time");
            this.folders = () -> ImmutableList.of((Object)folder);
            return this;
        }

        @Deprecated
        public Builder setFolders(Supplier<Collection<File>> folderSupplier) {
            Preconditions.checkState((this.fileCollection == null && this.artifactCollection == null ? 1 : 0) != 0, (Object)"Cannot set file collection, artifact collection and jars/folders at the same time");
            this.folders = folderSupplier;
            return this;
        }

        @Deprecated
        public Builder setDependencies(List<? extends Object> dependencies) {
            Preconditions.checkState((this.fileCollection == null && this.artifactCollection == null ? 1 : 0) != 0, (Object)"Cannot set dependency when file collection or artifact collection is used");
            this.dependencies = ImmutableList.copyOf(dependencies);
            return this;
        }

        @Deprecated
        public Builder setDependency(Object dependency) {
            Preconditions.checkState((this.fileCollection == null && this.artifactCollection == null ? 1 : 0) != 0, (Object)"Cannot set dependency when file collection or artifact collection is used");
            this.dependencies = ImmutableList.of((Object)dependency);
            return this;
        }

        public Builder setFileCollection(FileCollection fileCollection) {
            Preconditions.checkState((this.jarFiles == null && this.folders == null && this.dependencies == null && this.artifactCollection == null ? 1 : 0) != 0, (Object)"Cannot set file collection, artifact collection and jars/folders at the same time");
            this.fileCollection = fileCollection;
            return this;
        }

        public Builder setArtifactCollection(ArtifactCollection artifactCollection) {
            Preconditions.checkState((this.jarFiles == null && this.folders == null && this.dependencies == null && this.fileCollection == null ? 1 : 0) != 0, (Object)"Cannot set file collection, artifact collection and jars/folders at the same time");
            this.artifactCollection = artifactCollection;
            return this;
        }
    }
}

