/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.utils.FileUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.workers.IsolationMode;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.OfflineInstrumentationAccessGenerator;

public class JacocoTransform
extends Transform {
    private static final Pattern CLASS_PATTERN = Pattern.compile(".*\\.class$");
    private static final Pattern KOTLIN_MODULE_PATTERN = Pattern.compile("^META-INF/.*\\.kotlin_module$");
    private final Configuration jacocoAntTaskConfiguration;

    public JacocoTransform(Configuration jacocoAntTaskConfiguration) {
        this.jacocoAntTaskConfiguration = jacocoAntTaskConfiguration;
    }

    public String getName() {
        return "jacoco";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_CLASS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.PROJECT, (Enum[])new QualifiedContent.Scope[0]);
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean isCacheable() {
        return true;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        return ImmutableList.of((Object)SecondaryFile.nonIncremental((FileCollection)this.jacocoAntTaskConfiguration));
    }

    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        for (TransformInput input : invocation.getInputs()) {
            Preconditions.checkState((boolean)input.getJarInputs().isEmpty());
            for (DirectoryInput directoryInput : input.getDirectoryInputs()) {
                File inputDir = directoryInput.getFile();
                File outputDir = invocation.getOutputProvider().getContentLocation(directoryInput.getName(), this.getOutputTypes(), this.getScopes(), Format.DIRECTORY);
                FileUtils.mkdirs((File)outputDir);
                Map<Action, List<File>> toProcess = invocation.isIncremental() ? JacocoTransform.getFilesForInstrumentationIncrementally(inputDir, outputDir, directoryInput.getChangedFiles()) : JacocoTransform.getFilesForInstrumentationNonIncrementally(inputDir, outputDir);
                invocation.getContext().getWorkerExecutor().submit(JacocoWorkerAction.class, workerConfiguration -> {
                    workerConfiguration.setIsolationMode(IsolationMode.CLASSLOADER);
                    workerConfiguration.classpath((Iterable)this.jacocoAntTaskConfiguration.getFiles());
                    workerConfiguration.setParams(new Object[]{toProcess, inputDir, outputDir});
                });
            }
        }
        invocation.getContext().getWorkerExecutor().await();
    }

    private static Map<Action, List<File>> getFilesForInstrumentationIncrementally(File inputDir, File outputDir, Map<File, Status> changedFiles) throws IOException {
        HashMap toProcess = Maps.newHashMap();
        for (Map.Entry<File, Status> changedInput : changedFiles.entrySet()) {
            File inputFile = changedInput.getKey();
            Action fileAction = JacocoTransform.calculateAction(inputFile, inputDir);
            if (fileAction == Action.IGNORE) continue;
            Preconditions.checkState((fileAction == Action.COPY || fileAction == Action.INSTRUMENT ? 1 : 0) != 0);
            switch (changedInput.getValue()) {
                case REMOVED: {
                    File outputFile = new File(outputDir, FileUtils.relativePossiblyNonExistingPath((File)inputFile, (File)inputDir));
                    FileUtils.delete((File)outputFile);
                    break;
                }
                case ADDED: 
                case CHANGED: {
                    List files = toProcess.getOrDefault((Object)fileAction, new ArrayList());
                    files.add(inputFile);
                    toProcess.put(fileAction, files);
                    break;
                }
            }
        }
        return toProcess;
    }

    private static Map<Action, List<File>> getFilesForInstrumentationNonIncrementally(File inputDir, File outputDir) throws IOException {
        HashMap toProcess = Maps.newHashMap();
        FileUtils.cleanOutputDir((File)outputDir);
        FluentIterable files = FileUtils.getAllFiles((File)inputDir);
        block4: for (File inputFile : files) {
            Action fileAction = JacocoTransform.calculateAction(inputFile, inputDir);
            switch (fileAction) {
                case COPY: 
                case INSTRUMENT: {
                    List actionFiles = toProcess.getOrDefault((Object)fileAction, new ArrayList());
                    actionFiles.add(inputFile);
                    toProcess.put(fileAction, actionFiles);
                    continue block4;
                }
                case IGNORE: {
                    continue block4;
                }
            }
            throw new AssertionError((Object)("Unsupported Action: " + (Object)((Object)fileAction)));
        }
        return toProcess;
    }

    private static Action calculateAction(File inputFile, File inputDir) {
        String inputRelativePath = FileUtils.toSystemIndependentPath((String)FileUtils.relativePossiblyNonExistingPath((File)inputFile, (File)inputDir));
        for (Pattern pattern : Action.COPY.getPatterns()) {
            if (!pattern.matcher(inputRelativePath).matches()) continue;
            return Action.COPY;
        }
        for (Pattern pattern : Action.INSTRUMENT.getPatterns()) {
            if (!pattern.matcher(inputRelativePath).matches()) continue;
            return Action.INSTRUMENT;
        }
        return Action.IGNORE;
    }

    static /* synthetic */ Pattern access$000() {
        return KOTLIN_MODULE_PATTERN;
    }

    static /* synthetic */ Pattern access$100() {
        return CLASS_PATTERN;
    }

    private static class JacocoWorkerAction
    implements Runnable {
        private Map<Action, List<File>> inputs;
        private File inputDir;
        private File outputDir;

        @Inject
        public JacocoWorkerAction(Map<Action, List<File>> inputs, File inputDir, File outputDir) {
            this.inputs = inputs;
            this.inputDir = inputDir;
            this.outputDir = outputDir;
        }

        @Override
        public void run() {
            Instrumenter instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)new OfflineInstrumentationAccessGenerator());
            for (File toInstrument : this.inputs.getOrDefault((Object)Action.INSTRUMENT, (List<File>)ImmutableList.of())) {
                try {
                    InputStream inputStream = Files.asByteSource((File)toInstrument).openBufferedStream();
                    Throwable throwable = null;
                    try {
                        byte[] instrumented = instrumenter.instrument(inputStream, toInstrument.toString());
                        File outputFile = new File(this.outputDir, FileUtils.relativePath((File)toInstrument, (File)this.inputDir));
                        Files.createParentDirs((File)outputFile);
                        Files.write((byte[])instrumented, (File)outputFile);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to instrument file with Jacoco: " + toInstrument, e);
                }
            }
            for (File toCopy : this.inputs.getOrDefault((Object)Action.COPY, (List<File>)ImmutableList.of())) {
                File outputFile = new File(this.outputDir, FileUtils.relativePath((File)toCopy, (File)this.inputDir));
                try {
                    Files.createParentDirs((File)outputFile);
                    Files.copy((File)toCopy, (File)outputFile);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to copy file: " + toCopy, e);
                }
            }
        }
    }

    private static enum Action {
        COPY(JacocoTransform.access$000()),
        IGNORE(new Pattern[0]),
        INSTRUMENT(JacocoTransform.access$100());

        private final ImmutableList<Pattern> patterns;

        private Action(Pattern ... patterns) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (Pattern pattern : patterns) {
                Preconditions.checkNotNull((Object)pattern);
                builder.add((Object)pattern);
            }
            this.patterns = builder.build();
        }

        ImmutableList<Pattern> getPatterns() {
            return this.patterns;
        }
    }
}

