/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import com.android.build.VariantOutput;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantModel;
import com.android.build.gradle.internal.api.ApplicationVariantImpl;
import com.android.build.gradle.internal.api.BaseVariantImpl;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.build.gradle.internal.dsl.ProductFlavor;
import com.android.build.gradle.internal.dsl.SigningConfig;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.OutputFactory;
import com.android.build.gradle.internal.variant.ApplicationVariantData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantFactory;
import com.android.build.gradle.internal.variant.MultiOutputPolicy;
import com.android.build.gradle.internal.variant.VariantFactory;
import com.android.build.gradle.options.BooleanOption;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.core.VariantTypeImpl;
import com.android.builder.errors.EvalIssueException;
import com.android.builder.errors.EvalIssueReporter;
import com.android.builder.profile.Recorder;
import com.android.ide.common.build.ApkData;
import com.android.ide.common.build.ApkInfo;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.resources.Density;
import com.android.utils.Pair;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.NamedDomainObjectContainer;

public class ApplicationVariantFactory
extends BaseVariantFactory
implements VariantFactory {
    public ApplicationVariantFactory(GlobalScope globalScope, AndroidBuilder androidBuilder, AndroidConfig extension) {
        super(globalScope, androidBuilder, extension);
    }

    @Override
    public BaseVariantData createVariantData(GradleVariantConfiguration variantConfiguration, TaskManager taskManager, Recorder recorder) {
        ApplicationVariantData variant = new ApplicationVariantData(this.globalScope, this.extension, taskManager, variantConfiguration, recorder);
        variant.calculateFilters(this.extension.getSplits());
        Set<String> densities = variant.getFilters(VariantOutput.FilterType.DENSITY);
        Set<String> abis = variant.getFilters(VariantOutput.FilterType.ABI);
        this.checkSplitsConflicts(variant, abis);
        if (!densities.isEmpty()) {
            variant.setCompatibleScreens(this.extension.getSplits().getDensity().getCompatibleScreens());
        }
        OutputFactory outputFactory = variant.getOutputFactory();
        if (variant.getMultiOutputPolicy() == MultiOutputPolicy.MULTI_APK) {
            if (abis.isEmpty()) {
                if (densities.isEmpty()) {
                    outputFactory.addMainApk();
                } else {
                    outputFactory.addUniversalApk();
                }
            } else {
                if (this.extension.getSplits().getAbi().isEnable() && this.extension.getSplits().getAbi().isUniversalApk()) {
                    outputFactory.addUniversalApk();
                }
                abis.forEach(abi -> outputFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.ABI, (Object)abi))));
            }
            for (String density : densities) {
                if (!abis.isEmpty()) {
                    for (String abi2 : abis) {
                        outputFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.ABI, (Object)abi2), (Object)Pair.of((Object)VariantOutput.FilterType.DENSITY, (Object)density)));
                    }
                    continue;
                }
                outputFactory.addFullSplit((ImmutableList<Pair<VariantOutput.FilterType, String>>)ImmutableList.of((Object)Pair.of((Object)VariantOutput.FilterType.DENSITY, (Object)density)));
            }
        } else {
            outputFactory.addMainApk();
        }
        this.restrictEnabledOutputs(variantConfiguration, variant.getOutputScope().getApkDatas());
        return variant;
    }

    private void checkSplitsConflicts(ApplicationVariantData variantData, Set<String> abiFilters) {
        if (abiFilters.isEmpty()) {
            return;
        }
        if (this.extension.getSplits().getAbi().isUniversalApk()) {
            return;
        }
        Set<String> ndkConfigAbiFilters = ((GradleVariantConfiguration)variantData.getVariantConfiguration()).getNdkConfig().getAbiFilters();
        if (ndkConfigAbiFilters == null || ndkConfigAbiFilters.isEmpty()) {
            return;
        }
        EvalIssueReporter issueReporter = this.globalScope.getAndroidBuilder().getIssueReporter();
        issueReporter.reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException(String.format("Conflicting configuration : '%1$s' in ndk abiFilters cannot be present when splits abi filters are set : %2$s", Joiner.on((String)",").join(ndkConfigAbiFilters), Joiner.on((String)",").join(abiFilters))));
    }

    private void restrictEnabledOutputs(GradleVariantConfiguration configuration, List<ApkData> apkDataList) {
        String buildTargetAbi;
        Set<String> supportedAbis = configuration.getSupportedAbis();
        ProjectOptions projectOptions = this.globalScope.getProjectOptions();
        String string = buildTargetAbi = projectOptions.get(BooleanOption.BUILD_ONLY_TARGET_ABI) || this.globalScope.getExtension().getSplits().getAbi().isEnable() ? projectOptions.get(StringOption.IDE_BUILD_TARGET_ABI) : null;
        if (buildTargetAbi == null) {
            return;
        }
        String buildTargetDensity = projectOptions.get(StringOption.IDE_BUILD_TARGET_DENSITY);
        Density density = Density.getEnum((String)buildTargetDensity);
        List apksToGenerate = SplitOutputMatcher.computeBestOutput(apkDataList, supportedAbis, (int)(density == null ? -1 : density.getDpiValue()), Arrays.asList(Strings.nullToEmpty((String)buildTargetAbi).split(",")));
        if (apksToGenerate.isEmpty()) {
            List splits = apkDataList.stream().map(ApkInfo::getFilterName).filter(Objects::nonNull).collect(Collectors.toList());
            this.globalScope.getAndroidBuilder().getIssueReporter().reportWarning(EvalIssueReporter.Type.GENERIC, String.format("Cannot build selected target ABI: %1$s, " + (splits.isEmpty() ? "no suitable splits configured: %2$s;" : "supported ABIs are: %2$s"), buildTargetAbi, supportedAbis == null ? Joiner.on((String)", ").join(splits) : Joiner.on((String)", ").join(supportedAbis)));
            return;
        }
        apkDataList.forEach(apkData -> {
            if (!apksToGenerate.contains(apkData)) {
                apkData.disable();
            }
        });
    }

    @Override
    public Class<? extends BaseVariantImpl> getVariantImplementationClass(BaseVariantData variantData) {
        return ApplicationVariantImpl.class;
    }

    @Override
    public Collection<VariantType> getVariantConfigurationTypes() {
        if (this.extension.getBaseFeature().booleanValue()) {
            return ImmutableList.of((Object)VariantTypeImpl.BASE_APK);
        }
        return ImmutableList.of((Object)VariantTypeImpl.OPTIONAL_APK);
    }

    @Override
    public boolean hasTestScope() {
        return true;
    }

    @Override
    public void validateModel(VariantModel model) {
        if (this.getVariantConfigurationTypes().stream().noneMatch(VariantType::isFeatureSplit)) {
            return;
        }
        EvalIssueReporter issueReporter = this.androidBuilder.getIssueReporter();
        for (BuildTypeData buildType : model.getBuildTypes().values()) {
            if (!buildType.getBuildType().isMinifyEnabled()) continue;
            issueReporter.reportError(EvalIssueReporter.Type.GENERIC, new EvalIssueException("Dynamic feature modules cannot set minifyEnabled to true. minifyEnabled is set to true in build type '" + buildType.getBuildType().getName() + "'.\nTo enable minification for a dynamic feature module, set minifyEnabled to true in the base module."));
        }
    }

    @Override
    public void createDefaultComponents(NamedDomainObjectContainer<BuildType> buildTypes, NamedDomainObjectContainer<ProductFlavor> productFlavors, NamedDomainObjectContainer<SigningConfig> signingConfigs) {
        signingConfigs.create("debug");
        buildTypes.create("debug");
        buildTypes.create("release");
    }
}

