/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.AsmAbstractNode;
import com.android.build.gradle.internal.incremental.AsmInterfaceNode;
import java.util.List;
import java.util.function.Function;
import org.objectweb.asm.tree.ClassNode;

class AsmClassNode
extends AsmAbstractNode {
    private final AsmClassNode parent;
    private final List<AsmInterfaceNode> implementedInterfaces;

    AsmClassNode(ClassNode classNode, AsmClassNode parent, List<AsmInterfaceNode> implementedInterfaces) {
        super(classNode);
        this.parent = parent;
        this.implementedInterfaces = implementedInterfaces;
    }

    <T> T onHierarchy(Function<ClassNode, T> function) {
        T value = function.apply(this.getClassNode());
        if (value != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.onHierarchy(function);
        }
        return null;
    }

    <T> T onParents(Function<ClassNode, T> function) {
        if (this.parent != null) {
            T value = function.apply(this.parent.getClassNode());
            if (value != null) {
                return value;
            }
            return this.parent.onParents(function);
        }
        return null;
    }

    <T> T onAll(Function<ClassNode, T> function) {
        T value = function.apply(this.getClassNode());
        if (value != null) {
            return value;
        }
        for (AsmInterfaceNode implementedInterface : this.implementedInterfaces) {
            value = implementedInterface.onAll(function);
            if (value == null) continue;
            return value;
        }
        if (this.parent != null) {
            return this.parent.onAll(function);
        }
        return null;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public AsmClassNode getParent() {
        if (this.parent == null) {
            throw new IllegalStateException(String.format("getParent() called on %s which has not parent", this.getClassNode().name));
        }
        return this.parent;
    }

    public List<AsmInterfaceNode> getInterfaces() {
        return this.implementedInterfaces;
    }
}

