/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.ByteCodeUtils;
import com.android.build.gradle.internal.incremental.Constructor;
import com.android.build.gradle.internal.incremental.IncrementalVisitor;
import com.android.build.gradle.internal.incremental.Redirection;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.LabelNode;

public class ConstructorRedirection
extends Redirection {
    static final String DISPATCHING_THIS_SIGNATURE = "([Ljava/lang/Object;" + IncrementalVisitor.INSTANT_RELOAD_EXCEPTION.getDescriptor() + ")V";
    private final Constructor constructor;

    ConstructorRedirection(LabelNode label, Constructor constructor, List<Type> types) {
        super(label, types, Type.VOID_TYPE);
        this.constructor = constructor;
    }

    @Override
    protected void doRedirect(GeneratorAdapter mv, int change) {
        mv.loadLocal(change);
        mv.push("init$args." + this.constructor.args.desc);
        Type arrayType = Type.getType((String)"[Ljava/lang/Object;");
        mv.push(this.types.size() + 1);
        mv.newArray(Type.getType(Object.class));
        int array = mv.newLocal(arrayType);
        mv.dup();
        mv.storeLocal(array);
        mv.dup();
        mv.push(0);
        mv.visitInsn(1);
        mv.arrayStore(Type.getType(Object.class));
        ByteCodeUtils.loadVariableArray(mv, ByteCodeUtils.toLocalVariables(this.types), 1);
        mv.dup();
        mv.push(this.types.size());
        ByteCodeUtils.newVariableArray(mv, this.constructor.variables.subList(0, this.constructor.localsAtLoadThis));
        mv.arrayStore(Type.getType(Object.class));
        mv.invokeInterface(IncrementalVisitor.CHANGE_TYPE, Method.getMethod((String)"Object access$dispatch(String, Object[])"));
        mv.visitTypeInsn(192, "[Ljava/lang/Object;");
        mv.dup();
        mv.push(0);
        mv.arrayLoad(Type.getType((String)"[Ljava/lang/Object;"));
        mv.visitTypeInsn(192, "[Ljava/lang/Object;");
        mv.storeLocal(array);
        mv.visitVarInsn(25, 0);
        mv.swap();
        mv.visitInsn(1);
        mv.visitMethodInsn(183, this.constructor.owner, "<init>", DISPATCHING_THIS_SIGNATURE, false);
        mv.loadLocal(change);
        mv.push("init$body." + this.constructor.body.desc);
        mv.loadLocal(array);
        mv.dup();
        mv.push(0);
        mv.visitVarInsn(25, 0);
        mv.arrayStore(Type.getType(Object.class));
        mv.invokeInterface(IncrementalVisitor.CHANGE_TYPE, Method.getMethod((String)"Object access$dispatch(String, Object[])"));
        mv.pop();
    }
}

