/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunBuildMode;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.incremental.InstantRunVerifierStatus;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.InstantRunArtifact;
import com.google.wireless.android.sdk.stats.InstantRunStatus;

public class InstantRunAnalyticsHelper {
    public static InstantRunStatus generateAnalyticsProto(InstantRunBuildContext buildContext) {
        InstantRunStatus.Builder builder = InstantRunStatus.newBuilder();
        builder.setBuildMode(InstantRunAnalyticsHelper.convert(buildContext.getBuildMode()));
        builder.setPatchingPolicy(InstantRunAnalyticsHelper.convert(buildContext.getPatchingPolicy()));
        builder.setVerifierStatus(InstantRunAnalyticsHelper.convert(buildContext.getVerifierResult()));
        InstantRunBuildContext.Build last = buildContext.getLastBuild();
        if (last != null) {
            for (InstantRunBuildContext.Artifact artifact : last.getArtifacts()) {
                builder.addArtifact(InstantRunArtifact.newBuilder().setType(InstantRunAnalyticsHelper.convert(artifact.getType())));
            }
        }
        return builder.build();
    }

    @VisibleForTesting
    static InstantRunStatus.BuildMode convert(InstantRunBuildMode mode) {
        switch (mode) {
            case HOT_WARM: {
                return InstantRunStatus.BuildMode.HOT_WARM;
            }
            case COLD: {
                return InstantRunStatus.BuildMode.COLD;
            }
            case FULL: {
                return InstantRunStatus.BuildMode.FULL;
            }
        }
        return InstantRunStatus.BuildMode.UNKNOWN_BUILD_MODE;
    }

    @VisibleForTesting
    static InstantRunStatus.PatchingPolicy convert(InstantRunPatchingPolicy policy) {
        if (policy == null) {
            return InstantRunStatus.PatchingPolicy.UNKNOWN_PATCHING_POLICY;
        }
        switch (policy) {
            case MULTI_APK: {
                return InstantRunStatus.PatchingPolicy.MULTI_APK;
            }
            case MULTI_APK_SEPARATE_RESOURCES: {
                return InstantRunStatus.PatchingPolicy.MULTI_APK_SEPARATE_RESOURCES;
            }
        }
        return InstantRunStatus.PatchingPolicy.UNKNOWN_PATCHING_POLICY;
    }

    @VisibleForTesting
    static InstantRunStatus.VerifierStatus convert(InstantRunVerifierStatus status) {
        try {
            return InstantRunStatus.VerifierStatus.valueOf((String)status.toString());
        }
        catch (IllegalArgumentException ignored) {
            return InstantRunStatus.VerifierStatus.UNKNOWN_VERIFIER_STATUS;
        }
    }

    @VisibleForTesting
    static InstantRunArtifact.Type convert(FileType type) {
        switch (type) {
            case MAIN: {
                return InstantRunArtifact.Type.MAIN;
            }
            case SPLIT_MAIN: {
                return InstantRunArtifact.Type.SPLIT_MAIN;
            }
            case RELOAD_DEX: {
                return InstantRunArtifact.Type.RELOAD_DEX;
            }
            case SPLIT: {
                return InstantRunArtifact.Type.SPLIT;
            }
            case RESOURCES: {
                return InstantRunArtifact.Type.RESOURCES;
            }
        }
        throw new RuntimeException("Cannot convert " + (Object)((Object)type));
    }

    private InstantRunAnalyticsHelper() {
    }
}

